/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.dataloader.impl.Assertions;
import org.dataloader.impl.CompletableFutureKit;
import org.dataloader.impl.PromisedValues;

public class PromisedValuesImpl<T>
implements PromisedValues<T> {
    private final List<CompletionStage<T>> futures;
    private final CompletionStage<Void> controller;
    private AtomicReference<Throwable> cause;

    private PromisedValuesImpl(List<CompletionStage<T>> cs) {
        this.futures = Assertions.nonNull(cs);
        this.cause = new AtomicReference();
        List<CompletableFuture> cfs = cs.stream().map(CompletionStage::toCompletableFuture).collect(Collectors.toList());
        CompletableFuture[] futuresArray = cfs.toArray(new CompletableFuture[cfs.size()]);
        this.controller = CompletableFuture.allOf(futuresArray).handle((result, throwable) -> {
            this.setCause((Throwable)throwable);
            return null;
        });
    }

    private PromisedValuesImpl(PromisedValuesImpl<T> other, CompletionStage<Void> controller) {
        this.futures = other.futures;
        this.cause = other.cause;
        this.controller = controller;
    }

    public static <T> PromisedValues<T> combineAllOf(List<CompletionStage<T>> cfs) {
        return new PromisedValuesImpl<T>(Assertions.nonNull(cfs));
    }

    public static <T> PromisedValues<T> combinePromisedValues(List<PromisedValues<T>> promisedValues) {
        List<CompletionStage<T>> cfs = promisedValues.stream().map(pv -> (PromisedValuesImpl)pv).flatMap(pv -> pv.futures.stream()).collect(Collectors.toList());
        return new PromisedValuesImpl<T>(cfs);
    }

    private void setCause(Throwable throwable) {
        if (throwable != null) {
            if (throwable instanceof CompletionException && throwable.getCause() != null) {
                this.cause.set(throwable.getCause());
            } else {
                this.cause.set(throwable);
            }
        }
    }

    @Override
    public PromisedValues<T> thenAccept(Consumer<PromisedValues<T>> handler) {
        Assertions.nonNull(handler);
        CompletionStage<Void> newController = this.controller.handle((result, throwable) -> {
            this.setCause((Throwable)throwable);
            handler.accept(this);
            return result;
        });
        return new PromisedValuesImpl<T>(this, newController);
    }

    @Override
    public boolean succeeded() {
        return this.isDone() && this.cause.get() == null;
    }

    @Override
    public boolean failed() {
        return this.isDone() && this.cause.get() != null;
    }

    @Override
    public boolean isDone() {
        return this.controller.toCompletableFuture().isDone();
    }

    @Override
    public Throwable cause() {
        return this.cause.get();
    }

    @Override
    public boolean succeeded(int index) {
        return CompletableFutureKit.succeeded(this.futures.get(index).toCompletableFuture());
    }

    @Override
    public Throwable cause(int index) {
        return CompletableFutureKit.cause(this.futures.get(index).toCompletableFuture());
    }

    @Override
    public T get(int index) {
        Assertions.assertState(this.isDone(), "The PromisedValues MUST be complete before calling the get() method");
        try {
            CompletionStage<T> future = this.futures.get(index);
            return future.toCompletableFuture().get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    @Override
    public List<T> toList() {
        Assertions.assertState(this.isDone(), "The PromisedValues MUST be complete before calling the toList() method");
        int size = this.size();
        ArrayList<T> list = new ArrayList<T>(size);
        for (int index = 0; index < size; ++index) {
            list.add(this.get(index));
        }
        return list;
    }

    @Override
    public int size() {
        return this.futures.size();
    }

    @Override
    public List<T> join() {
        this.controller.toCompletableFuture().join();
        return this.toList();
    }

    @Override
    public CompletableFuture<List<T>> toCompletableFuture() {
        return this.controller.thenApply(v -> this.toList()).toCompletableFuture();
    }
}

