/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.regex;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.PublicApi;
import graphql.execution.CoercedVariables;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.scalars.util.Kit;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@PublicApi
public final class RegexScalar {
    private RegexScalar() {
    }

    private static GraphQLScalarType regexScalarImpl(final String name, String description, final List<Pattern> patterns) {
        Assert.assertNotNull(patterns);
        Coercing<String, String> coercing = new Coercing<String, String>(){

            public String serialize(Object input, GraphQLContext graphQLContext, Locale locale) throws CoercingSerializeException {
                String value = String.valueOf(input);
                return this.matches(value, CoercingSerializeException::new);
            }

            public String parseValue(Object input, GraphQLContext graphQLContext, Locale locale) throws CoercingParseValueException {
                String value = String.valueOf(input);
                return this.matches(value, CoercingParseValueException::new);
            }

            public String parseLiteral(Value<?> input, CoercedVariables variables, GraphQLContext graphQLContext, Locale locale) throws CoercingParseLiteralException {
                if (!(input instanceof StringValue)) {
                    throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + Kit.typeName(input) + "'.");
                }
                String value = ((StringValue)input).getValue();
                return this.matches(value, CoercingParseLiteralException::new);
            }

            public Value<?> valueToLiteral(Object input, GraphQLContext graphQLContext, Locale locale) {
                String s = this.serialize(input, graphQLContext, locale);
                return StringValue.newStringValue((String)s).build();
            }

            private String matches(String value, Function<String, RuntimeException> exceptionMaker) {
                for (Pattern pattern : patterns) {
                    Matcher matcher = pattern.matcher(value);
                    if (!matcher.matches()) continue;
                    return value;
                }
                throw exceptionMaker.apply("Unable to accept a value into the '" + name + "' scalar.  It does not match the regular expressions.");
            }
        };
        return GraphQLScalarType.newScalar().name(name).description(description).coercing((Coercing)coercing).build();
    }

    public static class Builder {
        private String name;
        private String description;
        private final List<Pattern> patterns = new ArrayList<Pattern>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder addPattern(Pattern pattern) {
            this.patterns.add(pattern);
            return this;
        }

        public Builder addPatterns(Pattern ... patterns) {
            Collections.addAll(this.patterns, patterns);
            return this;
        }

        public GraphQLScalarType build() {
            Assert.assertNotNull((Object)this.name);
            return RegexScalar.regexScalarImpl(this.name, this.description, this.patterns);
        }
    }
}

