/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.java;

import graphql.Internal;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.math.BigDecimal;
import java.math.BigInteger;

@Internal
public class JavaPrimitives {
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger INT_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger BYTE_MAX = BigInteger.valueOf(127L);
    private static final BigInteger BYTE_MIN = BigInteger.valueOf(-128L);
    private static final BigInteger SHORT_MAX = BigInteger.valueOf(32767L);
    private static final BigInteger SHORT_MIN = BigInteger.valueOf(-32768L);
    public static final GraphQLScalarType GraphQLLong = new GraphQLScalarType("Long", "Long type", (Coercing)new Coercing<Long, Long>(){

        private Long convertImpl(Object input) {
            if (input instanceof Long) {
                return (Long)input;
            }
            if (JavaPrimitives.isNumberIsh(input)) {
                BigDecimal value;
                try {
                    value = new BigDecimal(input.toString());
                }
                catch (NumberFormatException e) {
                    return null;
                }
                try {
                    return value.longValueExact();
                }
                catch (ArithmeticException e) {
                    return null;
                }
            }
            return null;
        }

        public Long serialize(Object input) {
            Long result = this.convertImpl(input);
            if (result == null) {
                throw new CoercingSerializeException("Expected type 'Long' but was '" + JavaPrimitives.typeName(input) + "'.");
            }
            return result;
        }

        public Long parseValue(Object input) {
            Long result = this.convertImpl(input);
            if (result == null) {
                throw new CoercingParseValueException("Expected type 'Long' but was '" + JavaPrimitives.typeName(input) + "'.");
            }
            return result;
        }

        public Long parseLiteral(Object input) {
            if (input instanceof StringValue) {
                try {
                    return Long.parseLong(((StringValue)input).getValue());
                }
                catch (NumberFormatException e) {
                    throw new CoercingParseLiteralException("Expected value to be a Long but it was '" + String.valueOf(input) + "'");
                }
            }
            if (input instanceof IntValue) {
                BigInteger value = ((IntValue)input).getValue();
                if (value.compareTo(LONG_MIN) < 0 || value.compareTo(LONG_MAX) > 0) {
                    throw new CoercingParseLiteralException("Expected value to be in the Long range but it was '" + value.toString() + "'");
                }
                return value.longValue();
            }
            throw new CoercingParseLiteralException("Expected AST type 'IntValue' or 'StringValue' but was '" + JavaPrimitives.typeName(input) + "'.");
        }
    });
    public static final GraphQLScalarType GraphQLShort = new GraphQLScalarType("Short", "Short as Int", (Coercing)new Coercing<Short, Short>(){

        private Short convertImpl(Object input) {
            if (input instanceof Short) {
                return (Short)input;
            }
            if (JavaPrimitives.isNumberIsh(input)) {
                BigDecimal value;
                try {
                    value = new BigDecimal(input.toString());
                }
                catch (NumberFormatException e) {
                    return null;
                }
                try {
                    return value.shortValueExact();
                }
                catch (ArithmeticException e) {
                    return null;
                }
            }
            return null;
        }

        public Short serialize(Object input) {
            Short result = this.convertImpl(input);
            if (result == null) {
                throw new CoercingSerializeException("Expected type 'Short' but was '" + JavaPrimitives.typeName(input) + "'.");
            }
            return result;
        }

        public Short parseValue(Object input) {
            Short result = this.convertImpl(input);
            if (result == null) {
                throw new CoercingParseValueException("Expected type 'Short' but was '" + JavaPrimitives.typeName(input) + "'.");
            }
            return result;
        }

        public Short parseLiteral(Object input) {
            if (!(input instanceof IntValue)) {
                throw new CoercingParseLiteralException("Expected AST type 'IntValue' but was '" + JavaPrimitives.typeName(input) + "'.");
            }
            BigInteger value = ((IntValue)input).getValue();
            if (value.compareTo(SHORT_MIN) < 0 || value.compareTo(SHORT_MAX) > 0) {
                throw new CoercingParseLiteralException("Expected value to be in the Short range but it was '" + value.toString() + "'");
            }
            return value.shortValue();
        }
    });
    public static final GraphQLScalarType GraphQLByte = new GraphQLScalarType("Byte", "Byte as Int", (Coercing)new Coercing<Byte, Byte>(){

        private Byte convertImpl(Object input) {
            if (input instanceof Byte) {
                return (Byte)input;
            }
            if (JavaPrimitives.isNumberIsh(input)) {
                BigDecimal value;
                try {
                    value = new BigDecimal(input.toString());
                }
                catch (NumberFormatException e) {
                    return null;
                }
                try {
                    return value.byteValueExact();
                }
                catch (ArithmeticException e) {
                    return null;
                }
            }
            return null;
        }

        public Byte serialize(Object input) {
            Byte result = this.convertImpl(input);
            if (result == null) {
                throw new CoercingSerializeException("Expected type 'Byte' but was '" + JavaPrimitives.typeName(input) + "'.");
            }
            return result;
        }

        public Byte parseValue(Object input) {
            Byte result = this.convertImpl(input);
            if (result == null) {
                throw new CoercingParseValueException("Expected type 'Byte' but was '" + JavaPrimitives.typeName(input) + "'.");
            }
            return result;
        }

        public Byte parseLiteral(Object input) {
            if (!(input instanceof IntValue)) {
                throw new CoercingParseLiteralException("Expected AST type 'IntValue' but was '" + JavaPrimitives.typeName(input) + "'.");
            }
            BigInteger value = ((IntValue)input).getValue();
            if (value.compareTo(BYTE_MIN) < 0 || value.compareTo(BYTE_MAX) > 0) {
                throw new CoercingParseLiteralException("Expected value to be in the Byte range but it was '" + value.toString() + "'");
            }
            return value.byteValue();
        }
    });
    public static final GraphQLScalarType GraphQLBigInteger = new GraphQLScalarType("BigInteger", "java.math.BigInteger", (Coercing)new Coercing<BigInteger, BigInteger>(){

        private BigInteger convertImpl(Object input) {
            if (JavaPrimitives.isNumberIsh(input)) {
                BigDecimal value;
                try {
                    value = new BigDecimal(input.toString());
                }
                catch (NumberFormatException e) {
                    return null;
                }
                try {
                    return value.toBigIntegerExact();
                }
                catch (ArithmeticException e) {
                    return null;
                }
            }
            return null;
        }

        public BigInteger serialize(Object input) {
            BigInteger result = this.convertImpl(input);
            if (result == null) {
                throw new CoercingSerializeException("Expected type 'BigInteger' but was '" + JavaPrimitives.typeName(input) + "'.");
            }
            return result;
        }

        public BigInteger parseValue(Object input) {
            BigInteger result = this.convertImpl(input);
            if (result == null) {
                throw new CoercingParseValueException("Expected type 'BigInteger' but was '" + JavaPrimitives.typeName(input) + "'.");
            }
            return result;
        }

        public BigInteger parseLiteral(Object input) {
            if (input instanceof StringValue) {
                try {
                    return new BigDecimal(((StringValue)input).getValue()).toBigIntegerExact();
                }
                catch (ArithmeticException | NumberFormatException e) {
                    throw new CoercingParseLiteralException("Unable to turn AST input into a 'BigInteger' : '" + String.valueOf(input) + "'");
                }
            }
            if (input instanceof IntValue) {
                return ((IntValue)input).getValue();
            }
            if (input instanceof FloatValue) {
                try {
                    return ((FloatValue)input).getValue().toBigIntegerExact();
                }
                catch (ArithmeticException e) {
                    throw new CoercingParseLiteralException("Unable to turn AST input into a 'BigInteger' : '" + String.valueOf(input) + "'");
                }
            }
            throw new CoercingParseLiteralException("Expected AST type 'IntValue', 'StringValue' or 'FloatValue' but was '" + JavaPrimitives.typeName(input) + "'.");
        }
    });
    public static final GraphQLScalarType GraphQLBigDecimal = new GraphQLScalarType("BigDecimal", "java.math.BigDecimal", (Coercing)new Coercing<BigDecimal, BigDecimal>(){

        private BigDecimal convertImpl(Object input) {
            if (JavaPrimitives.isNumberIsh(input)) {
                try {
                    return new BigDecimal(input.toString());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return null;
        }

        public BigDecimal serialize(Object input) {
            BigDecimal result = this.convertImpl(input);
            if (result == null) {
                throw new CoercingSerializeException("Expected type 'BigDecimal' but was '" + JavaPrimitives.typeName(input) + "'.");
            }
            return result;
        }

        public BigDecimal parseValue(Object input) {
            BigDecimal result = this.convertImpl(input);
            if (result == null) {
                throw new CoercingParseValueException("Expected type 'BigDecimal' but was '" + JavaPrimitives.typeName(input) + "'.");
            }
            return result;
        }

        public BigDecimal parseLiteral(Object input) {
            if (input instanceof StringValue) {
                try {
                    return new BigDecimal(((StringValue)input).getValue());
                }
                catch (NumberFormatException e) {
                    throw new CoercingParseLiteralException("Unable to turn AST input into a 'BigDecimal' : '" + String.valueOf(input) + "'");
                }
            }
            if (input instanceof IntValue) {
                return new BigDecimal(((IntValue)input).getValue());
            }
            if (input instanceof FloatValue) {
                return ((FloatValue)input).getValue();
            }
            throw new CoercingParseLiteralException("Expected AST type 'IntValue', 'StringValue' or 'FloatValue' but was '" + JavaPrimitives.typeName(input) + "'.");
        }
    });
    public static final GraphQLScalarType GraphQLChar = new GraphQLScalarType("Char", "Char as Character", (Coercing)new Coercing<Character, Character>(){

        private Character convertImpl(Object input) {
            if (input instanceof String && ((String)input).length() == 1) {
                return Character.valueOf(((String)input).charAt(0));
            }
            if (input instanceof Character) {
                return (Character)input;
            }
            return null;
        }

        public Character serialize(Object input) {
            Character result = this.convertImpl(input);
            if (result == null) {
                throw new CoercingSerializeException("Expected type 'Char' but was '" + JavaPrimitives.typeName(input) + "'.");
            }
            return result;
        }

        public Character parseValue(Object input) {
            Character result = this.convertImpl(input);
            if (result == null) {
                throw new CoercingParseValueException("Expected type 'Char' but was '" + JavaPrimitives.typeName(input) + "'.");
            }
            return result;
        }

        public Character parseLiteral(Object input) {
            if (!(input instanceof StringValue)) {
                throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + JavaPrimitives.typeName(input) + "'.");
            }
            String value = ((StringValue)input).getValue();
            if (value.length() != 1) {
                throw new CoercingParseLiteralException("Empty 'StringValue' provided.");
            }
            return Character.valueOf(value.charAt(0));
        }
    });

    private static boolean isNumberIsh(Object input) {
        return input instanceof Number || input instanceof String;
    }

    private static String typeName(Object input) {
        if (input == null) {
            return "null";
        }
        return input.getClass().getSimpleName();
    }
}

