/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.object;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.execution.CoercedVariables;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.scalars.util.Kit;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import graphql.util.FpKit;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

@Internal
public final class ObjectScalar {
    static final Coercing<Object, Object> OBJECT_COERCING = new Coercing<Object, Object>(){

        public Object serialize(Object input, GraphQLContext graphQLContext, Locale locale) throws CoercingSerializeException {
            return input;
        }

        public Object parseValue(Object input, GraphQLContext graphQLContext, Locale locale) throws CoercingParseValueException {
            return input;
        }

        public Object parseLiteral(Value<?> input, CoercedVariables variables, GraphQLContext graphQLContext, Locale locale) throws CoercingParseLiteralException {
            if (!(input instanceof Value)) {
                throw new CoercingParseLiteralException("Expected AST type 'Value' but was '" + Kit.typeName(input) + "'.");
            }
            if (input instanceof FloatValue) {
                return ((FloatValue)input).getValue();
            }
            if (input instanceof StringValue) {
                return ((StringValue)input).getValue();
            }
            if (input instanceof IntValue) {
                return ((IntValue)input).getValue();
            }
            if (input instanceof BooleanValue) {
                return ((BooleanValue)input).isValue();
            }
            if (input instanceof EnumValue) {
                return ((EnumValue)input).getName();
            }
            if (input instanceof VariableReference) {
                String varName = ((VariableReference)input).getName();
                return variables.get(varName);
            }
            if (input instanceof ArrayValue) {
                List values = ((ArrayValue)input).getValues();
                return values.stream().map(v -> this.parseLiteral((Value<?>)v, variables, graphQLContext, locale)).collect(Collectors.toList());
            }
            if (input instanceof ObjectValue) {
                List values = ((ObjectValue)input).getObjectFields();
                LinkedHashMap parsedValues = new LinkedHashMap();
                values.forEach(fld -> {
                    Object parsedValue = fld.getValue() instanceof NullValue ? null : this.parseLiteral(fld.getValue(), variables, graphQLContext, locale);
                    parsedValues.put(fld.getName(), parsedValue);
                });
                return parsedValues;
            }
            return Assert.assertShouldNeverHappen((String)"We have covered all Value types", (Object[])new Object[0]);
        }

        public Value<?> valueToLiteral(Object input, GraphQLContext graphQLContext, Locale locale) {
            if (input == null) {
                return NullValue.newNullValue().build();
            }
            if (input instanceof String) {
                return new StringValue((String)input);
            }
            if (input instanceof Float) {
                return new FloatValue(BigDecimal.valueOf(((Float)input).floatValue()));
            }
            if (input instanceof Double) {
                return new FloatValue(BigDecimal.valueOf((Double)input));
            }
            if (input instanceof BigDecimal) {
                return new FloatValue((BigDecimal)input);
            }
            if (input instanceof BigInteger) {
                return new IntValue((BigInteger)input);
            }
            if (input instanceof Number) {
                long l = ((Number)input).longValue();
                return new IntValue(BigInteger.valueOf(l));
            }
            if (input instanceof Boolean) {
                return new BooleanValue(((Boolean)input).booleanValue());
            }
            if (FpKit.isIterable((Object)input)) {
                return this.handleIterable(FpKit.toIterable((Object)input), graphQLContext, locale);
            }
            if (input instanceof Map) {
                return this.handleMap((Map)input, graphQLContext, locale);
            }
            throw new UnsupportedOperationException("The ObjectScalar cant handle values of type : " + String.valueOf(input.getClass()));
        }

        private Value<?> handleMap(Map<?, ?> map, GraphQLContext graphQLContext, Locale locale) {
            ObjectValue.Builder builder = ObjectValue.newObjectValue();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                String name = String.valueOf(entry.getKey());
                Value<?> value = this.valueToLiteral(entry.getValue(), graphQLContext, locale);
                builder.objectField(ObjectField.newObjectField().name(name).value(value).build());
            }
            return builder.build();
        }

        private Value<?> handleIterable(Iterable<?> input, GraphQLContext graphQLContext, Locale locale) {
            ArrayList values = new ArrayList();
            for (Object val : input) {
                values.add(this.valueToLiteral(val, graphQLContext, locale));
            }
            return ArrayValue.newArrayValue().values(values).build();
        }
    };
    public static GraphQLScalarType INSTANCE = GraphQLScalarType.newScalar().name("Object").description("An object scalar").coercing(OBJECT_COERCING).build();

    private ObjectScalar() {
    }
}

