/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars;

import graphql.PublicApi;
import graphql.scalars.alias.AliasedScalar;
import graphql.scalars.color.hex.HexColorCodeScalar;
import graphql.scalars.country.code.CountryCodeScalar;
import graphql.scalars.currency.CurrencyScalar;
import graphql.scalars.datetime.AccurateDurationScalar;
import graphql.scalars.datetime.DateScalar;
import graphql.scalars.datetime.DateTimeScalar;
import graphql.scalars.datetime.LocalTimeCoercing;
import graphql.scalars.datetime.NominalDurationScalar;
import graphql.scalars.datetime.TimeScalar;
import graphql.scalars.datetime.YearMonthScalar;
import graphql.scalars.datetime.YearScalar;
import graphql.scalars.id.UUIDScalar;
import graphql.scalars.java.JavaPrimitives;
import graphql.scalars.locale.LocaleScalar;
import graphql.scalars.numeric.NegativeFloatScalar;
import graphql.scalars.numeric.NegativeIntScalar;
import graphql.scalars.numeric.NonNegativeFloatScalar;
import graphql.scalars.numeric.NonNegativeIntScalar;
import graphql.scalars.numeric.NonPositiveFloatScalar;
import graphql.scalars.numeric.NonPositiveIntScalar;
import graphql.scalars.numeric.PositiveFloatScalar;
import graphql.scalars.numeric.PositiveIntScalar;
import graphql.scalars.object.JsonScalar;
import graphql.scalars.object.ObjectScalar;
import graphql.scalars.regex.RegexScalar;
import graphql.scalars.url.UrlScalar;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;

@PublicApi
public class ExtendedScalars {
    public static final GraphQLScalarType DateTime = DateTimeScalar.INSTANCE;
    public static final GraphQLScalarType Date = DateScalar.INSTANCE;
    public static final GraphQLScalarType Time = TimeScalar.INSTANCE;
    public static final GraphQLScalarType YearMonth = YearMonthScalar.INSTANCE;
    public static final GraphQLScalarType Year = YearScalar.INSTANCE;
    public static final GraphQLScalarType LocalTime = GraphQLScalarType.newScalar().name("LocalTime").description("24-hour clock time value string in the format `hh:mm:ss` or `hh:mm:ss.sss`.").coercing((Coercing)new LocalTimeCoercing()).build();
    public static final GraphQLScalarType AccurateDuration = AccurateDurationScalar.INSTANCE;
    public static final GraphQLScalarType NominalDuration = NominalDurationScalar.INSTANCE;
    public static final GraphQLScalarType Object = ObjectScalar.INSTANCE;
    public static final GraphQLScalarType Json = JsonScalar.INSTANCE;
    public static final GraphQLScalarType Url = UrlScalar.INSTANCE;
    public static final GraphQLScalarType Locale = LocaleScalar.INSTANCE;
    public static final GraphQLScalarType Currency = CurrencyScalar.INSTANCE;
    public static final GraphQLScalarType CountryCode = CountryCodeScalar.INSTANCE;
    public static final GraphQLScalarType HexColorCode = HexColorCodeScalar.INSTANCE;
    public static final GraphQLScalarType UUID = UUIDScalar.INSTANCE;
    public static final GraphQLScalarType PositiveInt = PositiveIntScalar.INSTANCE;
    public static final GraphQLScalarType NegativeInt = NegativeIntScalar.INSTANCE;
    public static final GraphQLScalarType NonPositiveInt = NonPositiveIntScalar.INSTANCE;
    public static final GraphQLScalarType NonNegativeInt = NonNegativeIntScalar.INSTANCE;
    public static final GraphQLScalarType PositiveFloat = PositiveFloatScalar.INSTANCE;
    public static final GraphQLScalarType NegativeFloat = NegativeFloatScalar.INSTANCE;
    public static final GraphQLScalarType NonPositiveFloat = NonPositiveFloatScalar.INSTANCE;
    public static final GraphQLScalarType NonNegativeFloat = NonNegativeFloatScalar.INSTANCE;
    public static final GraphQLScalarType GraphQLLong = JavaPrimitives.GraphQLLong;
    public static final GraphQLScalarType GraphQLShort = JavaPrimitives.GraphQLShort;
    public static final GraphQLScalarType GraphQLByte = JavaPrimitives.GraphQLByte;
    public static final GraphQLScalarType GraphQLBigDecimal = JavaPrimitives.GraphQLBigDecimal;
    public static final GraphQLScalarType GraphQLBigInteger = JavaPrimitives.GraphQLBigInteger;
    public static final GraphQLScalarType GraphQLChar = JavaPrimitives.GraphQLChar;

    public static RegexScalar.Builder newRegexScalar(String name) {
        return new RegexScalar.Builder().name(name);
    }

    public static AliasedScalar.Builder newAliasedScalar(String name) {
        return new AliasedScalar.Builder().name(name);
    }
}

