/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.country.code;

import graphql.Internal;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.scalars.country.code.CountryCode;
import graphql.scalars.util.Kit;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.util.function.Function;

@Internal
public class CountryCodeScalar {
    public static final GraphQLScalarType INSTANCE;

    static {
        Coercing<CountryCode, String> coercing = new Coercing<CountryCode, String>(){

            public String serialize(Object input) throws CoercingSerializeException {
                CountryCode countryCode = this.parseCountryCode(input, CoercingParseValueException::new);
                return countryCode.name();
            }

            public CountryCode parseValue(Object input) throws CoercingParseValueException {
                return this.parseCountryCode(input, CoercingParseValueException::new);
            }

            public CountryCode parseLiteral(Object input) throws CoercingParseLiteralException {
                if (!(input instanceof StringValue)) {
                    throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + Kit.typeName(input) + "'.");
                }
                String stringValue = ((StringValue)input).getValue();
                return this.parseCountryCode(stringValue, CoercingParseLiteralException::new);
            }

            public Value<?> valueToLiteral(Object input) {
                String s = this.serialize(input);
                return StringValue.newStringValue((String)s).build();
            }

            private CountryCode parseCountryCode(Object input, Function<String, RuntimeException> exceptionMaker) {
                CountryCode result;
                if (input instanceof String) {
                    try {
                        result = CountryCode.valueOf((String)input);
                    }
                    catch (IllegalArgumentException | NullPointerException ex) {
                        throw exceptionMaker.apply("Invalid ISO 3166-1 alpha-2 value : '" + input + "'. because of : '" + ex.getMessage() + "'");
                    }
                } else if (input instanceof CountryCode) {
                    result = (CountryCode)((Object)input);
                } else {
                    throw exceptionMaker.apply("Expected a 'String' or 'CountryCode' but was '" + Kit.typeName(input) + "'.");
                }
                return result;
            }
        };
        INSTANCE = GraphQLScalarType.newScalar().name("CountryCode").description("The CountryCode scalar type as defined by ISO 3166-1 alpha-2.").coercing((Coercing)coercing).build();
    }
}

