/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bytebuddy.TypeCache;
import net.bytebuddy.utility.nullability.AlwaysNull;
import net.bytebuddy.utility.nullability.MaybeNull;

public class TypeCache<T>
extends ReferenceQueue<ClassLoader> {
    @AlwaysNull
    private static final Class<?> NOT_FOUND = null;
    protected final Sort sort;
    protected final ConcurrentMap<StorageKey, ConcurrentMap<T, Object>> cache;

    public TypeCache() {
        this(Sort.STRONG);
    }

    public TypeCache(Sort sort) {
        this.sort = sort;
        this.cache = new ConcurrentHashMap();
    }

    @MaybeNull
    @SuppressFBWarnings(value={"GC_UNRELATED_TYPES"}, justification="Cross-comparison is intended.")
    public Class<?> find(@MaybeNull ClassLoader classLoader, T key) {
        ConcurrentMap storage = (ConcurrentMap)this.cache.get(new LookupKey(classLoader));
        if (storage == null) {
            return NOT_FOUND;
        }
        Object value = storage.get(key);
        if (value == null) {
            return NOT_FOUND;
        }
        if (value instanceof Reference) {
            return (Class)((Reference)value).get();
        }
        return (Class)value;
    }

    @SuppressFBWarnings(value={"GC_UNRELATED_TYPES"}, justification="Cross-comparison is intended.")
    public Class<?> insert(@MaybeNull ClassLoader classLoader, T key, Class<?> type) {
        ConcurrentMap previous;
        ConcurrentMap<T, Object> storage = (ConcurrentHashMap<T, Object>)this.cache.get(new LookupKey(classLoader));
        if (storage == null && (previous = (ConcurrentMap)this.cache.putIfAbsent(new StorageKey(classLoader, (ReferenceQueue)this), storage = new ConcurrentHashMap<T, Object>())) != null) {
            storage = previous;
        }
        Object value = this.sort.wrap(type);
        Object previous2 = storage.putIfAbsent(key, value);
        while (previous2 != null) {
            Class previousType = (Class)(previous2 instanceof Reference ? ((Reference)previous2).get() : previous2);
            if (previousType != null) {
                return previousType;
            }
            if (storage.remove(key, previous2)) {
                previous2 = storage.putIfAbsent(key, value);
                continue;
            }
            previous2 = storage.get(key);
            if (previous2 != null) continue;
            previous2 = storage.putIfAbsent(key, value);
        }
        return type;
    }

    public Class<?> findOrInsert(@MaybeNull ClassLoader classLoader, T key, Callable<Class<?>> lazy) {
        Class type = this.find(classLoader, key);
        if (type != null) {
            return type;
        }
        try {
            return this.insert(classLoader, key, lazy.call());
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Could not create type", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> findOrInsert(@MaybeNull ClassLoader classLoader, T key, Callable<Class<?>> lazy, Object monitor) {
        Class type = this.find(classLoader, key);
        if (type != null) {
            return type;
        }
        Object object = monitor;
        synchronized (object) {
            return this.findOrInsert(classLoader, key, lazy);
        }
    }

    public void expungeStaleEntries() {
        Reference reference;
        while ((reference = this.poll()) != null) {
            this.cache.remove(reference);
        }
    }

    public void clear() {
        this.cache.clear();
    }
}

