/*
 * Decompiled with CFR 0.152.
 */
package com.graphql.spring.boot.test;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphql.spring.boot.test.assertions.GraphQLErrorListAssertion;
import com.graphql.spring.boot.test.assertions.GraphQLFieldAssert;
import com.graphql.spring.boot.test.assertions.NumberOfErrorsAssertion;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.test.json.JsonContentAssert;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class GraphQLResponse {
    private final ResponseEntity<String> responseEntity;
    private final ObjectMapper mapper;
    private final ReadContext context;

    public GraphQLResponse(ResponseEntity<String> responseEntity, ObjectMapper objectMapper) {
        this.responseEntity = Objects.requireNonNull(responseEntity);
        this.mapper = Objects.requireNonNull(objectMapper);
        Objects.requireNonNull(responseEntity.getBody(), () -> "Body is empty with status " + responseEntity.getStatusCodeValue());
        this.context = JsonPath.parse((String)((String)responseEntity.getBody()));
    }

    public JsonNode readTree() throws IOException {
        return this.mapper.readTree((String)this.responseEntity.getBody());
    }

    public Object getRaw(String path) {
        return this.get(path, Object.class);
    }

    public String get(String path) {
        return this.get(path, String.class);
    }

    public <T> T get(String path, Class<T> type) {
        return (T)this.mapper.convertValue(this.context.read(path, new Predicate[0]), type);
    }

    public <T> T get(String path, JavaType type) {
        return (T)this.mapper.convertValue(this.context.read(path, new Predicate[0]), type);
    }

    public <T> List<T> getList(String path, Class<T> type) {
        return (List)this.get(path, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, type));
    }

    public ReadContext context() {
        return this.context;
    }

    public boolean isOk() {
        return this.getStatusCode() == HttpStatus.OK;
    }

    public HttpStatus getStatusCode() {
        return this.responseEntity.getStatusCode();
    }

    public ResponseEntity<String> getRawResponse() {
        return this.responseEntity;
    }

    public GraphQLResponse assertThatNoErrorsArePresent() {
        return this.assertThatListOfErrors().hasNoErrors().and();
    }

    public NumberOfErrorsAssertion assertThatNumberOfErrors() {
        return new NumberOfErrorsAssertion(this);
    }

    public GraphQLErrorListAssertion assertThatListOfErrors() {
        return new GraphQLErrorListAssertion(this);
    }

    public GraphQLFieldAssert assertThatField(String jsonPath) {
        return new GraphQLFieldAssert(this, jsonPath);
    }

    public GraphQLFieldAssert assertThatDataField() {
        return this.assertThatField("$.data");
    }

    public GraphQLFieldAssert assertThatExtensionsField() {
        return this.assertThatField("$.extensions");
    }

    public GraphQLFieldAssert assertThatErrorsField() {
        return this.assertThatField("$.errors");
    }

    public JsonContentAssert assertThatJsonContent() {
        return new JsonContentAssert(null, (CharSequence)this.responseEntity.getBody());
    }
}

