/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution.subscriptions.apollo;

import graphql.kickstart.execution.subscriptions.SubscriptionSession;
import graphql.kickstart.execution.subscriptions.apollo.ApolloSubscriptionConnectionListener;
import graphql.kickstart.execution.subscriptions.apollo.OperationMessage;
import graphql.kickstart.execution.subscriptions.apollo.SubscriptionCommand;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubscriptionConnectionInitCommand
implements SubscriptionCommand {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionConnectionInitCommand.class);
    private final Collection<ApolloSubscriptionConnectionListener> connectionListeners;

    @Override
    public void apply(SubscriptionSession session, OperationMessage message) {
        log.debug("Apollo subscription connection init: {}", (Object)session);
        try {
            this.connectionListeners.forEach(it -> it.onConnect(session, message));
            session.sendMessage(new OperationMessage(OperationMessage.Type.GQL_CONNECTION_ACK, message.getId(), null));
        }
        catch (Throwable t) {
            session.sendMessage(new OperationMessage(OperationMessage.Type.GQL_CONNECTION_ERROR, message.getId(), t.getMessage()));
        }
    }

    public SubscriptionConnectionInitCommand(Collection<ApolloSubscriptionConnectionListener> connectionListeners) {
        this.connectionListeners = connectionListeners;
    }
}

