/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution.subscriptions.apollo;

import graphql.kickstart.execution.GraphQLInvoker;
import graphql.kickstart.execution.subscriptions.GraphQLSubscriptionInvocationInputFactory;
import graphql.kickstart.execution.subscriptions.GraphQLSubscriptionMapper;
import graphql.kickstart.execution.subscriptions.apollo.ApolloSubscriptionConnectionListener;
import graphql.kickstart.execution.subscriptions.apollo.OperationMessage;
import graphql.kickstart.execution.subscriptions.apollo.SubscriptionCommand;
import graphql.kickstart.execution.subscriptions.apollo.SubscriptionConnectionInitCommand;
import graphql.kickstart.execution.subscriptions.apollo.SubscriptionConnectionTerminateCommand;
import graphql.kickstart.execution.subscriptions.apollo.SubscriptionStartCommand;
import graphql.kickstart.execution.subscriptions.apollo.SubscriptionStopCommand;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ApolloCommandProvider {
    private final Map<OperationMessage.Type, SubscriptionCommand> commands = new HashMap<OperationMessage.Type, SubscriptionCommand>();

    public ApolloCommandProvider(GraphQLSubscriptionMapper mapper, GraphQLSubscriptionInvocationInputFactory invocationInputFactory, GraphQLInvoker graphQLInvoker, Collection<ApolloSubscriptionConnectionListener> connectionListeners) {
        this.commands.put(OperationMessage.Type.GQL_CONNECTION_INIT, new SubscriptionConnectionInitCommand(connectionListeners));
        this.commands.put(OperationMessage.Type.GQL_START, new SubscriptionStartCommand(mapper, invocationInputFactory, graphQLInvoker, connectionListeners));
        this.commands.put(OperationMessage.Type.GQL_STOP, new SubscriptionStopCommand(connectionListeners));
        this.commands.put(OperationMessage.Type.GQL_CONNECTION_TERMINATE, new SubscriptionConnectionTerminateCommand(connectionListeners));
    }

    public SubscriptionCommand getByType(OperationMessage.Type type) {
        if (this.commands.containsKey((Object)type)) {
            return this.commands.get((Object)type);
        }
        throw new IllegalStateException("No command found for type " + (Object)((Object)type));
    }
}

