/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution.subscriptions;

import graphql.ExecutionResult;
import graphql.kickstart.execution.subscriptions.AtomicSubscriptionSubscription;
import graphql.kickstart.execution.subscriptions.SubscriptionSession;
import java.util.HashMap;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionSubscriber
implements Subscriber<ExecutionResult> {
    private static final Logger log = LoggerFactory.getLogger(SessionSubscriber.class);
    private final SubscriptionSession session;
    private final String id;
    private AtomicSubscriptionSubscription subscriptionReference = new AtomicSubscriptionSubscription();

    public void onSubscribe(Subscription subscription) {
        log.debug("Subscribe to execution result: {}", (Object)subscription);
        this.subscriptionReference.set(subscription);
        this.subscriptionReference.get().request(1L);
        this.session.add(this.id, this.subscriptionReference.get());
    }

    public void onNext(ExecutionResult executionResult) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("data", executionResult.getData());
        this.session.sendDataMessage(this.id, result);
        this.subscriptionReference.get().request(1L);
    }

    public void onError(Throwable throwable) {
        log.error("Subscription error", throwable);
        this.session.unsubscribe(this.id);
        this.session.sendErrorMessage(this.id);
    }

    public void onComplete() {
        this.session.unsubscribe(this.id);
        this.session.sendCompleteMessage(this.id);
    }

    public SessionSubscriber(SubscriptionSession session, String id) {
        this.session = session;
        this.id = id;
    }
}

