/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import graphql.ExecutionResult;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.servlet.QueryResponseWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class BatchedQueryResponseWriter
implements QueryResponseWriter {
    private final List<ExecutionResult> results;
    private final GraphQLObjectMapper graphQLObjectMapper;

    @Override
    public void write(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        response.setStatus(200);
        Iterator<ExecutionResult> executionInputIterator = this.results.iterator();
        StringBuilder responseBuilder = new StringBuilder();
        responseBuilder.append('[');
        while (executionInputIterator.hasNext()) {
            responseBuilder.append(this.graphQLObjectMapper.serializeResultAsJson(executionInputIterator.next()));
            if (!executionInputIterator.hasNext()) continue;
            responseBuilder.append(',');
        }
        responseBuilder.append(']');
        String responseContent = responseBuilder.toString();
        response.setContentLength(responseContent.length());
        response.getWriter().write(responseContent);
    }

    public BatchedQueryResponseWriter(List<ExecutionResult> results, GraphQLObjectMapper graphQLObjectMapper) {
        this.results = results;
        this.graphQLObjectMapper = graphQLObjectMapper;
    }
}

