/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet.core.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.reactivestreams.Subscription;

public class WsSessionSubscriptions {
    private final Object lock = new Object();
    private boolean closed = false;
    private Map<String, Subscription> subscriptions = new ConcurrentHashMap<String, Subscription>();

    public void add(Subscription subscription) {
        this.add(this.getImplicitId(subscription), subscription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String id, Subscription subscription) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("Websocket was already closed!");
            }
            this.subscriptions.put(id, subscription);
        }
    }

    public void cancel(Subscription subscription) {
        this.cancel(this.getImplicitId(subscription));
    }

    public void cancel(String id) {
        Subscription subscription = this.subscriptions.remove(id);
        if (subscription != null) {
            subscription.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
            this.subscriptions.forEach((k, v) -> v.cancel());
            this.subscriptions.clear();
        }
    }

    private String getImplicitId(Subscription subscription) {
        return String.valueOf(subscription.hashCode());
    }

    public int getSubscriptionCount() {
        return this.subscriptions.size();
    }
}

