/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet.core;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentationOptions;
import graphql.execution.preparsed.NoOpPreparsedDocumentProvider;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.GraphQLSchema;
import graphql.servlet.config.DefaultExecutionStrategyProvider;
import graphql.servlet.config.ExecutionStrategyProvider;
import graphql.servlet.context.ContextSetting;
import graphql.servlet.input.GraphQLSingleInvocationInput;
import java.security.AccessController;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.security.auth.Subject;

public class GraphQLQueryInvoker {
    private final Supplier<ExecutionStrategyProvider> getExecutionStrategyProvider;
    private final Supplier<Instrumentation> getInstrumentation;
    private final Supplier<PreparsedDocumentProvider> getPreparsedDocumentProvider;
    private final Supplier<DataLoaderDispatcherInstrumentationOptions> optionsSupplier;

    protected GraphQLQueryInvoker(Supplier<ExecutionStrategyProvider> getExecutionStrategyProvider, Supplier<Instrumentation> getInstrumentation, Supplier<PreparsedDocumentProvider> getPreparsedDocumentProvider, Supplier<DataLoaderDispatcherInstrumentationOptions> optionsSupplier) {
        this.getExecutionStrategyProvider = getExecutionStrategyProvider;
        this.getInstrumentation = getInstrumentation;
        this.getPreparsedDocumentProvider = getPreparsedDocumentProvider;
        this.optionsSupplier = optionsSupplier;
    }

    public ExecutionResult query(GraphQLSingleInvocationInput singleInvocationInput) {
        return this.queryAsync(singleInvocationInput, this.getInstrumentation).join();
    }

    private CompletableFuture<ExecutionResult> queryAsync(GraphQLSingleInvocationInput singleInvocationInput, Supplier<Instrumentation> configuredInstrumentation) {
        return this.query(singleInvocationInput, configuredInstrumentation, singleInvocationInput.getExecutionInput());
    }

    public List<ExecutionResult> query(List<GraphQLSingleInvocationInput> batchedInvocationInput, ContextSetting contextSetting) {
        List<ExecutionInput> executionIds = batchedInvocationInput.stream().map(GraphQLSingleInvocationInput::getExecutionInput).collect(Collectors.toList());
        Supplier<Instrumentation> configuredInstrumentation = contextSetting.configureInstrumentationForContext(this.getInstrumentation, executionIds, this.optionsSupplier.get());
        return batchedInvocationInput.stream().map(input -> this.queryAsync((GraphQLSingleInvocationInput)input, configuredInstrumentation)).collect(Collectors.toList()).stream().map(CompletableFuture::join).collect(Collectors.toList());
    }

    private GraphQL newGraphQL(GraphQLSchema schema, Supplier<Instrumentation> configuredInstrumentation) {
        ExecutionStrategyProvider executionStrategyProvider = this.getExecutionStrategyProvider.get();
        GraphQL.Builder builder = GraphQL.newGraphQL((GraphQLSchema)schema).queryExecutionStrategy(executionStrategyProvider.getQueryExecutionStrategy()).mutationExecutionStrategy(executionStrategyProvider.getMutationExecutionStrategy()).subscriptionExecutionStrategy(executionStrategyProvider.getSubscriptionExecutionStrategy()).preparsedDocumentProvider(this.getPreparsedDocumentProvider.get());
        Instrumentation instrumentation = configuredInstrumentation.get();
        builder.instrumentation(instrumentation);
        if (this.containsDispatchInstrumentation(instrumentation)) {
            builder.doNotAddDefaultInstrumentations();
        }
        return builder.build();
    }

    private boolean containsDispatchInstrumentation(Instrumentation instrumentation) {
        if (instrumentation instanceof ChainedInstrumentation) {
            return ((ChainedInstrumentation)instrumentation).getInstrumentations().stream().anyMatch(this::containsDispatchInstrumentation);
        }
        return instrumentation instanceof DataLoaderDispatcherInstrumentation;
    }

    private CompletableFuture<ExecutionResult> query(GraphQLSingleInvocationInput invocationInput, Supplier<Instrumentation> configuredInstrumentation, ExecutionInput executionInput) {
        if (Subject.getSubject(AccessController.getContext()) == null && invocationInput.getSubject().isPresent()) {
            return Subject.doAs(invocationInput.getSubject().get(), () -> {
                try {
                    return this.query(invocationInput.getSchema(), executionInput, configuredInstrumentation);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return this.query(invocationInput.getSchema(), executionInput, configuredInstrumentation);
    }

    private CompletableFuture<ExecutionResult> query(GraphQLSchema schema, ExecutionInput executionInput, Supplier<Instrumentation> configuredInstrumentation) {
        return this.newGraphQL(schema, configuredInstrumentation).executeAsync(executionInput);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Supplier<ExecutionStrategyProvider> getExecutionStrategyProvider = DefaultExecutionStrategyProvider::new;
        private Supplier<Instrumentation> getInstrumentation = () -> SimpleInstrumentation.INSTANCE;
        private Supplier<PreparsedDocumentProvider> getPreparsedDocumentProvider = () -> NoOpPreparsedDocumentProvider.INSTANCE;
        private Supplier<DataLoaderDispatcherInstrumentationOptions> dataLoaderDispatcherInstrumentationOptionsSupplier = DataLoaderDispatcherInstrumentationOptions::newOptions;

        public Builder withExecutionStrategyProvider(ExecutionStrategyProvider provider) {
            return this.withExecutionStrategyProvider(() -> provider);
        }

        public Builder withExecutionStrategyProvider(Supplier<ExecutionStrategyProvider> supplier) {
            this.getExecutionStrategyProvider = supplier;
            return this;
        }

        public Builder withInstrumentation(Instrumentation instrumentation) {
            return this.withInstrumentation(() -> instrumentation);
        }

        public Builder withInstrumentation(Supplier<Instrumentation> supplier) {
            this.getInstrumentation = supplier;
            return this;
        }

        public Builder with(List<Instrumentation> instrumentations) {
            if (instrumentations.isEmpty()) {
                return this;
            }
            if (instrumentations.size() == 1) {
                this.withInstrumentation(instrumentations.get(0));
            } else {
                this.withInstrumentation((Instrumentation)new ChainedInstrumentation(instrumentations));
            }
            return this;
        }

        public Builder withPreparsedDocumentProvider(PreparsedDocumentProvider provider) {
            return this.withPreparsedDocumentProvider(() -> provider);
        }

        public Builder withPreparsedDocumentProvider(Supplier<PreparsedDocumentProvider> supplier) {
            this.getPreparsedDocumentProvider = supplier;
            return this;
        }

        public Builder withDataLoaderDispatcherInstrumentationOptions(DataLoaderDispatcherInstrumentationOptions options) {
            return this.withDataLoaderDispatcherInstrumentationOptions(() -> options);
        }

        public Builder withDataLoaderDispatcherInstrumentationOptions(Supplier<DataLoaderDispatcherInstrumentationOptions> supplier) {
            this.dataLoaderDispatcherInstrumentationOptionsSupplier = supplier;
            return this;
        }

        public GraphQLQueryInvoker build() {
            return new GraphQLQueryInvoker(this.getExecutionStrategyProvider, this.getInstrumentation, this.getPreparsedDocumentProvider, this.dataLoaderDispatcherInstrumentationOptionsSupplier);
        }
    }
}

