/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet.context;

import graphql.ExecutionInput;
import graphql.execution.ExecutionId;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentationOptions;
import graphql.schema.GraphQLSchema;
import graphql.servlet.context.GraphQLContext;
import graphql.servlet.core.internal.GraphQLRequest;
import graphql.servlet.input.GraphQLBatchedInvocationInput;
import graphql.servlet.input.PerQueryBatchedInvocationInput;
import graphql.servlet.input.PerRequestBatchedInvocationInput;
import graphql.servlet.instrumentation.ConfigurableDispatchInstrumentation;
import graphql.servlet.instrumentation.FieldLevelTrackingApproach;
import graphql.servlet.instrumentation.RequestLevelTrackingApproach;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.dataloader.DataLoaderRegistry;

public enum ContextSetting {
    PER_REQUEST_WITH_INSTRUMENTATION,
    PER_REQUEST_WITHOUT_INSTRUMENTATION,
    PER_QUERY_WITH_INSTRUMENTATION,
    PER_QUERY_WITHOUT_INSTRUMENTATION;


    public GraphQLBatchedInvocationInput getBatch(List<GraphQLRequest> requests, GraphQLSchema schema, Supplier<GraphQLContext> contextSupplier, Object root) {
        switch (this) {
            case PER_QUERY_WITH_INSTRUMENTATION: 
            case PER_QUERY_WITHOUT_INSTRUMENTATION: {
                return new PerQueryBatchedInvocationInput(requests, schema, contextSupplier, root);
            }
            case PER_REQUEST_WITHOUT_INSTRUMENTATION: 
            case PER_REQUEST_WITH_INSTRUMENTATION: {
                return new PerRequestBatchedInvocationInput(requests, schema, contextSupplier, root);
            }
        }
        throw new RuntimeException("Unconfigured context setting type");
    }

    public Supplier<Instrumentation> configureInstrumentationForContext(Supplier<Instrumentation> instrumentation, List<ExecutionInput> executionInputs, DataLoaderDispatcherInstrumentationOptions options) {
        ConfigurableDispatchInstrumentation dispatchInstrumentation;
        switch (this) {
            case PER_REQUEST_WITH_INSTRUMENTATION: {
                DataLoaderRegistry registry = executionInputs.stream().findFirst().map(ExecutionInput::getDataLoaderRegistry).orElseThrow(IllegalArgumentException::new);
                List<ExecutionId> executionIds = executionInputs.stream().map(ExecutionInput::getExecutionId).collect(Collectors.toList());
                RequestLevelTrackingApproach requestTrackingApproach = new RequestLevelTrackingApproach(executionIds, registry);
                dispatchInstrumentation = new ConfigurableDispatchInstrumentation(options, dataLoaderRegistry -> requestTrackingApproach);
                break;
            }
            case PER_QUERY_WITH_INSTRUMENTATION: {
                dispatchInstrumentation = new ConfigurableDispatchInstrumentation(options, FieldLevelTrackingApproach::new);
                break;
            }
            case PER_QUERY_WITHOUT_INSTRUMENTATION: 
            case PER_REQUEST_WITHOUT_INSTRUMENTATION: {
                return instrumentation::get;
            }
            default: {
                throw new RuntimeException("Unconfigured context setting type");
            }
        }
        return () -> new ChainedInstrumentation(Arrays.asList(new Instrumentation[]{dispatchInstrumentation, (Instrumentation)instrumentation.get()}));
    }
}

