/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet.config;

import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.servlet.config.ExecutionStrategyProvider;

public class DefaultExecutionStrategyProvider
implements ExecutionStrategyProvider {
    private final ExecutionStrategy queryExecutionStrategy;
    private final ExecutionStrategy mutationExecutionStrategy;
    private final ExecutionStrategy subscriptionExecutionStrategy;

    public DefaultExecutionStrategyProvider() {
        this(null);
    }

    public DefaultExecutionStrategyProvider(ExecutionStrategy executionStrategy) {
        this(executionStrategy, null, null);
    }

    public DefaultExecutionStrategyProvider(ExecutionStrategy queryExecutionStrategy, ExecutionStrategy mutationExecutionStrategy, ExecutionStrategy subscriptionExecutionStrategy) {
        this.queryExecutionStrategy = this.defaultIfNull(queryExecutionStrategy, (ExecutionStrategy)new AsyncExecutionStrategy());
        this.mutationExecutionStrategy = this.defaultIfNull(mutationExecutionStrategy, this.queryExecutionStrategy);
        this.subscriptionExecutionStrategy = this.defaultIfNull(subscriptionExecutionStrategy, (ExecutionStrategy)new SubscriptionExecutionStrategy());
    }

    private ExecutionStrategy defaultIfNull(ExecutionStrategy executionStrategy, ExecutionStrategy defaultStrategy) {
        return executionStrategy != null ? executionStrategy : defaultStrategy;
    }

    @Override
    public ExecutionStrategy getQueryExecutionStrategy() {
        return this.queryExecutionStrategy;
    }

    @Override
    public ExecutionStrategy getMutationExecutionStrategy() {
        return this.mutationExecutionStrategy;
    }

    @Override
    public ExecutionStrategy getSubscriptionExecutionStrategy() {
        return this.subscriptionExecutionStrategy;
    }
}

