/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet.cache;

import graphql.kickstart.execution.input.GraphQLInvocationInput;
import graphql.kickstart.servlet.GraphQLConfiguration;
import graphql.kickstart.servlet.HttpRequestInvoker;
import graphql.kickstart.servlet.HttpRequestInvokerImpl;
import graphql.kickstart.servlet.cache.CacheReader;
import graphql.kickstart.servlet.cache.CachingQueryResponseWriterFactory;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingHttpRequestInvoker
implements HttpRequestInvoker {
    private static final Logger log = LoggerFactory.getLogger(CachingHttpRequestInvoker.class);
    private final GraphQLConfiguration configuration;
    private final HttpRequestInvoker requestInvoker;

    public CachingHttpRequestInvoker(GraphQLConfiguration configuration) {
        this.configuration = configuration;
        this.requestInvoker = new HttpRequestInvokerImpl(configuration, configuration.getGraphQLInvoker(), new CachingQueryResponseWriterFactory());
    }

    @Override
    public void execute(GraphQLInvocationInput invocationInput, HttpServletRequest request, HttpServletResponse response) {
        boolean returnedFromCache;
        try {
            returnedFromCache = !CacheReader.responseFromCache(invocationInput, request, response, this.configuration.getResponseCacheManager());
        }
        catch (IOException e) {
            response.setStatus(400);
            log.warn("Unexpected error happened during response from cache", (Throwable)e);
            return;
        }
        if (!returnedFromCache) {
            this.requestInvoker.execute(invocationInput, request, response);
        }
    }
}

