/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet.cache;

import graphql.kickstart.execution.input.GraphQLInvocationInput;
import graphql.kickstart.servlet.cache.CachedResponse;
import graphql.kickstart.servlet.cache.GraphQLResponseCacheManager;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheReader {
    private static final Logger log = LoggerFactory.getLogger(CacheReader.class);

    private CacheReader() {
    }

    public static boolean responseFromCache(GraphQLInvocationInput invocationInput, HttpServletRequest request, HttpServletResponse response, GraphQLResponseCacheManager cacheManager) throws IOException {
        CachedResponse cachedResponse = null;
        try {
            cachedResponse = cacheManager.get(request, invocationInput);
        }
        catch (Exception t) {
            log.warn("Ignore read from cache, unexpected error happened", (Throwable)t);
        }
        if (cachedResponse != null) {
            CacheReader.write(response, cachedResponse);
            return true;
        }
        return false;
    }

    private static void write(HttpServletResponse response, CachedResponse cachedResponse) throws IOException {
        if (cachedResponse.isError()) {
            response.sendError(cachedResponse.getErrorStatusCode().intValue(), cachedResponse.getErrorMessage());
        } else {
            response.setContentType("application/json;charset=UTF-8");
            response.setStatus(200);
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.setContentLength(cachedResponse.getContentBytes().length);
            response.getOutputStream().write(cachedResponse.getContentBytes());
        }
    }
}

