/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedHttpServletResponse
extends HttpServletResponseWrapper {
    private static final Logger log = LoggerFactory.getLogger(BufferedHttpServletResponse.class);
    private BufferedOutputStream copier;
    private ServletOutputStream outputStream;
    private PrintWriter writer;
    private String errorMessage;

    public BufferedHttpServletResponse(HttpServletResponse response) {
        super(response);
    }

    public void sendError(int sc, String msg) throws IOException {
        this.errorMessage = msg;
        super.sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, null);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called on this response.");
        }
        if (this.outputStream == null) {
            this.outputStream = this.getResponse().getOutputStream();
            this.copier = new BufferedOutputStream((OutputStream)this.outputStream);
        }
        return this.copier;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputStream != null) {
            throw new IllegalStateException("getOutputStream() has already been called on this response.");
        }
        if (this.writer == null) {
            this.copier = new BufferedOutputStream((OutputStream)this.getResponse().getOutputStream());
            this.writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)((Object)this.copier), this.getResponse().getCharacterEncoding()), true);
        }
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        } else if (this.copier != null) {
            this.copier.flush();
        }
    }

    public boolean isCommitted() {
        return false;
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        } else if (this.copier != null) {
            this.copier.close();
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public byte[] getContentAsByteArray() {
        if (this.copier != null) {
            return this.copier.toByteArray();
        }
        return new byte[0];
    }

    private static final class BufferedOutputStream
    extends ServletOutputStream {
        private final OutputStream delegate;
        private final ByteArrayOutputStream buf = new ByteArrayOutputStream();

        public BufferedOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        public void write(int b) throws IOException {
            this.buf.write(b);
            this.delegate.write(b);
        }

        public void flush() throws IOException {
            this.buf.flush();
            this.delegate.flush();
        }

        public void close() throws IOException {
            this.buf.close();
            this.delegate.close();
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }

        public byte[] toByteArray() {
            return this.buf.toByteArray();
        }
    }
}

