/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.kickstart.execution.GraphQLInvoker;
import graphql.kickstart.execution.GraphQLQueryResult;
import graphql.kickstart.execution.input.GraphQLBatchedInvocationInput;
import graphql.kickstart.execution.input.GraphQLInvocationInput;
import graphql.kickstart.execution.input.GraphQLSingleInvocationInput;
import graphql.kickstart.servlet.GraphQLConfiguration;
import graphql.kickstart.servlet.HttpRequestInvoker;
import graphql.kickstart.servlet.QueryResponseWriter;
import graphql.kickstart.servlet.QueryResponseWriterFactory;
import graphql.kickstart.servlet.input.BatchInputPreProcessResult;
import graphql.kickstart.servlet.input.BatchInputPreProcessor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.CompletableFuture;
import javax.servlet.AsyncContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestInvokerImpl
implements HttpRequestInvoker {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestInvokerImpl.class);
    private final GraphQLConfiguration configuration;
    private final GraphQLInvoker graphQLInvoker;
    private final QueryResponseWriterFactory queryResponseWriterFactory;

    @Override
    public void execute(GraphQLInvocationInput invocationInput, HttpServletRequest request, HttpServletResponse response) {
        if (request.isAsyncSupported()) {
            AsyncContext asyncContext = request.isAsyncStarted() ? request.getAsyncContext() : request.startAsync((ServletRequest)request, (ServletResponse)response);
            asyncContext.setTimeout(this.configuration.getAsyncTimeout());
            ((CompletableFuture)((CompletableFuture)this.invoke(invocationInput, request, response).thenAccept(result -> this.writeResultResponse(invocationInput, (GraphQLQueryResult)result, request, response))).exceptionally(t -> this.writeErrorResponse((Throwable)t, response))).thenAccept(aVoid -> asyncContext.complete());
        } else {
            try {
                GraphQLQueryResult result2 = this.invoke(invocationInput, request, response).join();
                this.writeResultResponse(invocationInput, result2, request, response);
            }
            catch (Exception t2) {
                this.writeErrorResponse(t2, response);
            }
        }
    }

    private void writeResultResponse(GraphQLInvocationInput invocationInput, GraphQLQueryResult queryResult, HttpServletRequest request, HttpServletResponse response) {
        QueryResponseWriter queryResponseWriter = this.createWriter(invocationInput, queryResult);
        try {
            queryResponseWriter.write(request, response);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected QueryResponseWriter createWriter(GraphQLInvocationInput invocationInput, GraphQLQueryResult queryResult) {
        return this.queryResponseWriterFactory.createWriter(invocationInput, queryResult, this.configuration);
    }

    private Void writeErrorResponse(Throwable t, HttpServletResponse response) {
        response.setStatus(400);
        log.info("Bad request: path was not \"/schema.json\" or no query variable named \"query\" given", t);
        return null;
    }

    private CompletableFuture<GraphQLQueryResult> invoke(GraphQLInvocationInput invocationInput, HttpServletRequest request, HttpServletResponse response) {
        if (invocationInput instanceof GraphQLSingleInvocationInput) {
            return this.graphQLInvoker.queryAsync(invocationInput);
        }
        return this.invokeBatched((GraphQLBatchedInvocationInput)invocationInput, request, response);
    }

    private CompletableFuture<GraphQLQueryResult> invokeBatched(GraphQLBatchedInvocationInput batchedInvocationInput, HttpServletRequest request, HttpServletResponse response) {
        BatchInputPreProcessor preprocessor = this.configuration.getBatchInputPreProcessor();
        BatchInputPreProcessResult result = preprocessor.preProcessBatch(batchedInvocationInput, request, response);
        if (result.isExecutable()) {
            return this.graphQLInvoker.queryAsync((GraphQLInvocationInput)result.getBatchedInvocationInput());
        }
        return CompletableFuture.completedFuture(GraphQLQueryResult.createError((int)result.getStatusCode(), (String)result.getStatusMessage()));
    }

    public HttpRequestInvokerImpl(GraphQLConfiguration configuration, GraphQLInvoker graphQLInvoker, QueryResponseWriterFactory queryResponseWriterFactory) {
        this.configuration = configuration;
        this.graphQLInvoker = graphQLInvoker;
        this.queryResponseWriterFactory = queryResponseWriterFactory;
    }
}

