/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.GraphQLException;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.execution.GraphQLRequest;
import graphql.kickstart.execution.context.ContextSetting;
import graphql.kickstart.execution.input.GraphQLInvocationInput;
import graphql.kickstart.servlet.AbstractGraphQLInvocationInputParser;
import graphql.kickstart.servlet.PartIOException;
import graphql.kickstart.servlet.core.internal.VariableMapper;
import graphql.kickstart.servlet.input.GraphQLInvocationInputFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GraphQLMultipartInvocationInputParser
extends AbstractGraphQLInvocationInputParser {
    private static final Logger log = LoggerFactory.getLogger(GraphQLMultipartInvocationInputParser.class);
    private static final String[] MULTIPART_KEYS = new String[]{"operations", "graphql", "query"};

    GraphQLMultipartInvocationInputParser(GraphQLInvocationInputFactory invocationInputFactory, GraphQLObjectMapper graphQLObjectMapper, ContextSetting contextSetting) {
        super(invocationInputFactory, graphQLObjectMapper, contextSetting);
    }

    @Override
    public GraphQLInvocationInput getGraphQLInvocationInput(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            Map<String, List<Part>> parts = request.getParts().stream().collect(Collectors.groupingBy(Part::getName));
            for (String key : MULTIPART_KEYS) {
                if (!parts.containsKey(key)) continue;
                Optional<Part> queryItem = this.findPart(parts);
                if (!queryItem.isPresent()) {
                    log.info("Bad POST multipart request: no part named {}", (Object)Arrays.toString(MULTIPART_KEYS));
                    throw new GraphQLException("Bad POST multipart request: no part named " + Arrays.toString(MULTIPART_KEYS));
                }
                return this.getGraphQLInvocationInput(request, response, parts, key, queryItem.get());
            }
            log.info("Bad POST multipart request: no part named {}", (Object)Arrays.toString(MULTIPART_KEYS));
            throw new GraphQLException("Bad POST multipart request: no part named " + Arrays.toString(MULTIPART_KEYS));
        }
        catch (ServletException e) {
            throw new IOException("Cannot get parts from request", e);
        }
    }

    private GraphQLInvocationInput getGraphQLInvocationInput(HttpServletRequest request, HttpServletResponse response, Map<String, List<Part>> parts, String key, Part queryItem) throws IOException {
        InputStream inputStream = queryItem.getInputStream();
        Optional<Map> variablesMap = this.getPart(parts, "map").map(part -> {
            try (InputStream is = part.getInputStream();){
                Map map = this.graphQLObjectMapper.deserializeMultipartMap(is);
                return map;
            }
            catch (IOException e) {
                throw new PartIOException("Unable to read input stream from part", e);
            }
        });
        String query = this.read(inputStream);
        if ("query".equals(key) && this.isSingleQuery(query)) {
            GraphQLRequest graphqlRequest = this.buildRequestFromQuery(query, this.graphQLObjectMapper, parts);
            variablesMap.ifPresent(m -> this.mapMultipartVariables(graphqlRequest, (Map<String, List<String>>)m, parts));
            return this.invocationInputFactory.create(graphqlRequest, request, response);
        }
        if (this.isSingleQuery(query)) {
            GraphQLRequest graphqlRequest = this.graphQLObjectMapper.readGraphQLRequest(query);
            variablesMap.ifPresent(m -> this.mapMultipartVariables(graphqlRequest, (Map<String, List<String>>)m, parts));
            return this.invocationInputFactory.create(graphqlRequest, request, response);
        }
        List graphqlRequests = this.graphQLObjectMapper.readBatchedGraphQLRequest(query);
        variablesMap.ifPresent(map -> graphqlRequests.forEach(r -> this.mapMultipartVariables((GraphQLRequest)r, (Map<String, List<String>>)map, parts)));
        return this.invocationInputFactory.create(this.contextSetting, graphqlRequests, request, response);
    }

    private Optional<Part> findPart(Map<String, List<Part>> parts) {
        return Arrays.stream(MULTIPART_KEYS).filter(parts::containsKey).map(key -> this.getPart(parts, (String)key)).findFirst().map(Optional::get);
    }

    private Optional<Part> getPart(Map<String, List<Part>> parts, String name) {
        return Optional.ofNullable(parts.get(name)).filter(list -> !list.isEmpty()).map(list -> (Part)list.get(0));
    }

    private void mapMultipartVariables(GraphQLRequest request, Map<String, List<String>> variablesMap, Map<String, List<Part>> fileItems) {
        Map variables = request.getVariables();
        variablesMap.forEach((partName, objectPaths) -> {
            Part part = this.getPart(fileItems, (String)partName).orElseThrow(() -> new RuntimeException("unable to find part name " + partName + " as referenced in the variables map"));
            objectPaths.forEach(objectPath -> VariableMapper.mapVariable(objectPath, variables, part));
        });
    }

    private GraphQLRequest buildRequestFromQuery(String query, GraphQLObjectMapper graphQLObjectMapper, Map<String, List<Part>> parts) throws IOException {
        Map variables = null;
        Optional<Part> variablesItem = this.getPart(parts, "variables");
        if (variablesItem.isPresent()) {
            variables = graphQLObjectMapper.deserializeVariables(this.read(variablesItem.get().getInputStream()));
        }
        String operationName = null;
        Optional<Part> operationNameItem = this.getPart(parts, "operationName");
        if (operationNameItem.isPresent()) {
            operationName = this.read(operationNameItem.get().getInputStream()).trim();
        }
        return new GraphQLRequest(query, variables, operationName);
    }

    /*
     * Exception decompiling
     */
    private String read(InputStream inputStream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

