/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.servlet;

import graphql.ExecutionResult;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.servlet.QueryResponseWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchedQueryResponseWriter
implements QueryResponseWriter {
    private static final Logger log = LoggerFactory.getLogger(BatchedQueryResponseWriter.class);
    private final List<ExecutionResult> results;
    private final GraphQLObjectMapper graphQLObjectMapper;

    @Override
    public void write(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        response.setStatus(200);
        Iterator<ExecutionResult> executionInputIterator = this.results.iterator();
        StringBuilder responseBuilder = new StringBuilder();
        responseBuilder.append('[');
        while (executionInputIterator.hasNext()) {
            responseBuilder.append(this.graphQLObjectMapper.serializeResultAsJson(executionInputIterator.next()));
            if (!executionInputIterator.hasNext()) continue;
            responseBuilder.append(',');
        }
        responseBuilder.append(']');
        String responseContent = responseBuilder.toString();
        byte[] contentBytes = responseContent.getBytes(StandardCharsets.UTF_8);
        response.setContentLength(contentBytes.length);
        response.getOutputStream().write(contentBytes);
    }

    public BatchedQueryResponseWriter(List<ExecutionResult> results, GraphQLObjectMapper graphQLObjectMapper) {
        this.results = results;
        this.graphQLObjectMapper = graphQLObjectMapper;
    }
}

