/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.GraphHopper;
import com.graphhopper.util.GitInfo;
import com.graphhopper.util.Helper;
import java.io.InputStreamReader;
import java.util.List;
import java.util.StringTokenizer;

public class Constants {
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String OS_NAME = System.getProperty("os.name");
    public static final boolean LINUX = OS_NAME.startsWith("Linux");
    public static final boolean ANDROID = System.getProperty("java.vendor").contains("Android");
    public static final boolean WINDOWS = OS_NAME.startsWith("Windows");
    public static final boolean SUN_OS = OS_NAME.startsWith("SunOS");
    public static final boolean MAC_OS_X = OS_NAME.startsWith("Mac OS X");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String JAVA_VENDOR = System.getProperty("java.vendor");
    public static final String JVM_SPEC_VERSION = System.getProperty("java.specification.version");
    public static final boolean JRE_IS_MINIMUM_JAVA9;
    private static final int JVM_MAJOR_VERSION;
    private static final int JVM_MINOR_VERSION;
    public static final int VERSION_NODE = 7;
    public static final int VERSION_EDGE = 20;
    public static final int VERSION_SHORTCUT = 7;
    public static final int VERSION_GEOMETRY = 5;
    public static final int VERSION_LOCATION_IDX = 4;
    public static final int VERSION_STRING_IDX = 5;
    public static final String VERSION;
    public static final String BUILD_DATE;
    public static final GitInfo GIT_INFO;
    public static final boolean SNAPSHOT;

    public static String getVersions() {
        return "7,20,5,4,5,7";
    }

    public static String getMajorVersion() {
        int firstIdx = VERSION.indexOf(".");
        if (firstIdx < 0) {
            throw new IllegalStateException("Cannot extract major version from version " + VERSION);
        }
        int sndIdx = VERSION.indexOf(".", firstIdx + 1);
        if (sndIdx < 0) {
            return VERSION;
        }
        return VERSION.substring(0, sndIdx);
    }

    static {
        StringTokenizer st = new StringTokenizer(JVM_SPEC_VERSION, ".");
        JVM_MAJOR_VERSION = Integer.parseInt(st.nextToken());
        JVM_MINOR_VERSION = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 0;
        JRE_IS_MINIMUM_JAVA9 = JVM_MAJOR_VERSION > 1 || JVM_MAJOR_VERSION == 1 && JVM_MINOR_VERSION >= 9;
        String version = "0.0";
        try {
            List<String> v = Helper.readFile(new InputStreamReader(GraphHopper.class.getResourceAsStream("version"), Helper.UTF_CS));
            version = v.get(0);
        }
        catch (Exception ex) {
            System.err.println("GraphHopper Initialization ERROR: cannot read version!? " + ex.getMessage());
        }
        int indexM = version.indexOf("-");
        if ("${project.version}".equals(version)) {
            VERSION = "0.0";
            SNAPSHOT = true;
            System.err.println("GraphHopper Initialization WARNING: maven did not preprocess the version file! Do not use the jar for a release!");
        } else if ("0.0".equals(version)) {
            VERSION = "0.0";
            SNAPSHOT = true;
            System.err.println("GraphHopper Initialization WARNING: cannot get version!?");
        } else {
            String tmp = version;
            if (indexM >= 0) {
                tmp = version.substring(0, indexM);
            }
            SNAPSHOT = Helper.toLowerCase(version).contains("-snapshot");
            VERSION = tmp;
        }
        String buildDate = "";
        try {
            List<String> v = Helper.readFile(new InputStreamReader(GraphHopper.class.getResourceAsStream("builddate"), Helper.UTF_CS));
            buildDate = v.get(0);
        }
        catch (Exception v) {
            // empty catch block
        }
        BUILD_DATE = buildDate;
        List<String> gitInfos = null;
        try {
            gitInfos = Helper.readFile(new InputStreamReader(GraphHopper.class.getResourceAsStream("gitinfo"), Helper.UTF_CS));
            if (gitInfos.size() != 6) {
                System.err.println("GraphHopper Initialization WARNING: unexpected git info: " + gitInfos.toString());
                gitInfos = null;
            } else if (gitInfos.get(1).startsWith("$")) {
                gitInfos = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GIT_INFO = gitInfos == null ? null : new GitInfo(gitInfos.get(1), gitInfos.get(2), gitInfos.get(3), gitInfos.get(4), Boolean.parseBoolean(gitInfos.get(5)));
    }
}

