/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.util.Helper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorableProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorableProperties.class);
    private final Map<String, String> map = new LinkedHashMap<String, String>();
    private final DataAccess da;

    public StorableProperties(Directory dir) {
        this.da = dir.find("properties");
        this.da.setSegmentSize(32768);
    }

    public synchronized boolean loadExisting() {
        if (!this.da.loadExisting()) {
            return false;
        }
        int len = (int)this.da.getCapacity();
        byte[] bytes = new byte[len];
        this.da.getBytes(0L, bytes, len);
        try {
            StorableProperties.loadProperties(this.map, new StringReader(new String(bytes, Helper.UTF_CS)));
            return true;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public synchronized void flush() {
        try {
            StringWriter sw = new StringWriter();
            Helper.saveProperties(this.map, sw);
            byte[] bytes = sw.toString().getBytes(Helper.UTF_CS);
            this.da.setBytes(0L, bytes, bytes.length);
            this.da.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized StorableProperties remove(String key) {
        this.map.remove(key);
        return this;
    }

    public synchronized StorableProperties putAll(Map<String, String> externMap) {
        this.map.putAll(externMap);
        return this;
    }

    public synchronized StorableProperties put(String key, String val) {
        this.map.put(key, val);
        return this;
    }

    public synchronized StorableProperties put(String key, Object val) {
        if (!key.equals(Helper.toLowerCase(key))) {
            throw new IllegalArgumentException("Do not use upper case keys (" + key + ") for StorableProperties since 0.7");
        }
        this.map.put(key, val.toString());
        return this;
    }

    public synchronized String get(String key) {
        if (!key.equals(Helper.toLowerCase(key))) {
            throw new IllegalArgumentException("Do not use upper case keys (" + key + ") for StorableProperties since 0.7");
        }
        String ret = this.map.get(key);
        if (ret == null) {
            return "";
        }
        return ret;
    }

    public synchronized void close() {
        this.da.close();
    }

    public synchronized boolean isClosed() {
        return this.da.isClosed();
    }

    public synchronized StorableProperties create(long size) {
        this.da.create(size);
        return this;
    }

    public synchronized long getCapacity() {
        return this.da.getCapacity();
    }

    public synchronized void putCurrentVersions() {
        this.put("nodes.version", 7);
        this.put("edges.version", 20);
        this.put("geometry.version", 5);
        this.put("location_index.version", 4);
        this.put("string_index.version", 5);
        this.put("shortcuts.version", 7);
    }

    public synchronized String versionsToString() {
        return this.get("nodes.version") + "," + this.get("edges.version") + "," + this.get("geometry.version") + "," + this.get("location_index.version") + "," + this.get("string_index.version");
    }

    public synchronized boolean checkVersions(boolean silent) {
        if (!this.check("nodes", 7, silent)) {
            return false;
        }
        if (!this.check("edges", 20, silent)) {
            return false;
        }
        if (!this.check("geometry", 5, silent)) {
            return false;
        }
        if (!this.check("location_index", 4, silent)) {
            return false;
        }
        if (!this.check("string_index", 5, silent)) {
            return false;
        }
        return this.check("shortcuts", 7, silent);
    }

    boolean check(String key, int vers, boolean silent) {
        String str = this.get(key + ".version");
        if (!str.equals(vers + "")) {
            if (silent) {
                return false;
            }
            throw new IllegalStateException("Version of " + key + " unsupported: " + str + ", expected:" + vers + ". Make sure you are using the same GraphHopper version for reading the files that was used for creating them. See https://discuss.graphhopper.com/t/722");
        }
        return true;
    }

    public synchronized String toString() {
        return this.da.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadProperties(Map<String, String> map, Reader tmpReader) throws IOException {
        try (BufferedReader reader = new BufferedReader(tmpReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("//") || line.startsWith("#") || Helper.isEmpty(line)) continue;
                int index = line.indexOf("=");
                if (index < 0) {
                    LOGGER.warn("Skipping configuration at line:" + line);
                    continue;
                }
                String field = line.substring(0, index);
                String value = line.substring(index + 1);
                map.put(field.trim(), value.trim());
            }
        }
    }
}

