/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.BBox;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphHopperStorage
implements Graph,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphHopperStorage.class);
    private final Directory dir;
    private final EncodingManager encodingManager;
    private final StorableProperties properties;
    private final BaseGraph baseGraph;
    private final Collection<CHEntry> chEntries;
    private final int segmentSize;

    public GraphHopperStorage(Directory dir, EncodingManager encodingManager, boolean withElevation) {
        this(dir, encodingManager, withElevation, false);
    }

    public GraphHopperStorage(Directory dir, EncodingManager encodingManager, boolean withElevation, boolean withTurnCosts) {
        this(dir, encodingManager, withElevation, withTurnCosts, -1);
    }

    public GraphHopperStorage(Directory dir, EncodingManager encodingManager, boolean withElevation, boolean withTurnCosts, int segmentSize) {
        if (encodingManager == null) {
            throw new IllegalArgumentException("EncodingManager needs to be non-null since 0.7. Create one using EncodingManager.create or EncodingManager.create(flagEncoderFactory, ghLocation)");
        }
        this.encodingManager = encodingManager;
        this.dir = dir;
        this.properties = new StorableProperties(dir);
        this.segmentSize = segmentSize;
        this.baseGraph = new BaseGraph(dir, encodingManager.getIntsForFlags(), withElevation, withTurnCosts, segmentSize);
        this.chEntries = new ArrayList<CHEntry>();
    }

    public GraphHopperStorage addCHGraph(CHConfig chConfig) {
        this.baseGraph.checkNotInitialized();
        if (this.getCHConfigs().contains(chConfig)) {
            throw new IllegalArgumentException("For the given CH profile a CHStorage already exists: '" + chConfig.getName() + "'");
        }
        if (chConfig.getWeighting() == null) {
            throw new IllegalStateException("Weighting for CHConfig must not be null");
        }
        CHStorage store = new CHStorage(this.dir, chConfig.getName(), this.segmentSize, chConfig.isEdgeBased());
        store.setLowShortcutWeightConsumer(s2 -> {
            NodeAccess nodeAccess = this.baseGraph.getNodeAccess();
            LOGGER.warn("Setting weights smaller than " + s2.minWeight + " is not allowed. You passed: " + s2.weight + " for the shortcut  nodeA (" + nodeAccess.getLat(s2.nodeA) + "," + nodeAccess.getLon(s2.nodeA) + " nodeB " + nodeAccess.getLat(s2.nodeB) + "," + nodeAccess.getLon(s2.nodeB));
        });
        this.chEntries.add(new CHEntry(chConfig, store, new RoutingCHGraphImpl(this.baseGraph, store, chConfig.getWeighting())));
        return this;
    }

    public GraphHopperStorage addCHGraphs(List<CHConfig> chConfigs) {
        for (CHConfig chConfig : chConfigs) {
            this.addCHGraph(chConfig);
        }
        return this;
    }

    public CHStorage getCHStore() {
        return this.getCHEntry().chStore;
    }

    public CHStorage getCHStore(String chName) {
        CHEntry chEntry = this.getCHEntry(chName);
        return chEntry == null ? null : chEntry.chStore;
    }

    public CHConfig getCHConfig() {
        return this.getCHEntry().chConfig;
    }

    public CHConfig getCHConfig(String chName) {
        CHEntry chEntry = this.getCHEntry(chName);
        return chEntry == null ? null : chEntry.chConfig;
    }

    public RoutingCHGraph getRoutingCHGraph() {
        return this.getCHEntry().chGraph;
    }

    public RoutingCHGraph getRoutingCHGraph(String chName) {
        CHEntry chEntry = this.getCHEntry(chName);
        return chEntry == null ? null : chEntry.chGraph;
    }

    private CHEntry getCHEntry() {
        if (this.chEntries.isEmpty()) {
            throw new IllegalStateException("There are no CHs");
        }
        if (this.chEntries.size() > 1) {
            throw new IllegalStateException("There are multiple CHs, use get...(name) to retrieve a specific one");
        }
        return this.chEntries.iterator().next();
    }

    public CHEntry getCHEntry(String chName) {
        for (CHEntry cg : this.chEntries) {
            if (!cg.chConfig.getName().equals(chName)) continue;
            return cg;
        }
        return null;
    }

    public List<String> getCHGraphNames() {
        return this.chEntries.stream().map(ch -> ch.chConfig.getName()).collect(Collectors.toList());
    }

    public boolean isCHPossible() {
        return !this.chEntries.isEmpty();
    }

    public List<CHConfig> getCHConfigs() {
        return this.chEntries.stream().map(c -> c.chConfig).collect(Collectors.toList());
    }

    public List<CHConfig> getCHConfigs(boolean edgeBased) {
        ArrayList<CHConfig> result = new ArrayList<CHConfig>();
        List<CHConfig> chConfigs = this.getCHConfigs();
        for (CHConfig profile : chConfigs) {
            if (edgeBased != profile.isEdgeBased()) continue;
            result.add(profile);
        }
        return result;
    }

    public Directory getDirectory() {
        return this.dir;
    }

    public GraphHopperStorage create(long byteCount) {
        this.baseGraph.checkNotInitialized();
        if (this.encodingManager == null) {
            throw new IllegalStateException("EncodingManager can only be null if you call loadExisting");
        }
        this.dir.create();
        long initSize = Math.max(byteCount, 100L);
        this.properties.create(100L);
        this.properties.put("graph.encoded_values", this.encodingManager.toEncodedValuesAsString());
        this.properties.put("graph.flag_encoders", this.encodingManager.toFlagEncodersAsString());
        this.properties.put("graph.byte_order", this.dir.getByteOrder());
        this.properties.put("graph.dimension", this.baseGraph.nodeAccess.getDimension());
        this.properties.putCurrentVersions();
        this.baseGraph.create(initSize);
        this.chEntries.forEach(ch -> ch.chStore.create());
        List<CHConfig> chConfigs = this.getCHConfigs();
        ArrayList<String> chProfileNames = new ArrayList<String>(chConfigs.size());
        for (CHConfig chConfig : chConfigs) {
            chProfileNames.add(chConfig.getName());
        }
        this.properties.put("graph.ch.profiles", ((Object)chProfileNames).toString());
        return this;
    }

    public EncodingManager getEncodingManager() {
        return this.encodingManager;
    }

    public StorableProperties getProperties() {
        return this.properties;
    }

    public boolean loadExisting() {
        this.baseGraph.checkNotInitialized();
        if (this.properties.loadExisting()) {
            this.properties.checkVersions(false);
            String flagEncodersStr = this.properties.get("graph.flag_encoders");
            if (!this.encodingManager.toFlagEncodersAsString().equalsIgnoreCase(flagEncodersStr)) {
                throw new IllegalStateException("Encoding does not match:\nGraphhopper config: " + this.encodingManager.toFlagEncodersAsString() + "\nGraph: " + flagEncodersStr + "\nChange configuration to match the graph or delete " + this.dir.getLocation());
            }
            String encodedValueStr = this.properties.get("graph.encoded_values");
            if (!this.encodingManager.toEncodedValuesAsString().equalsIgnoreCase(encodedValueStr)) {
                throw new IllegalStateException("Encoded values do not match:\nGraphhopper config: " + this.encodingManager.toEncodedValuesAsString() + "\nGraph: " + encodedValueStr + "\nChange configuration to match the graph or delete " + this.dir.getLocation());
            }
            String byteOrder = this.properties.get("graph.byte_order");
            if (!byteOrder.equalsIgnoreCase("" + this.dir.getByteOrder())) {
                throw new IllegalStateException("Configured graph.byte_order (" + this.dir.getByteOrder() + ") is not equal to loaded " + byteOrder + "");
            }
            String dim = this.properties.get("graph.dimension");
            this.baseGraph.loadExisting(dim);
            this.checkIfConfiguredAndLoadedWeightingsCompatible();
            this.chEntries.forEach(cg -> {
                if (!cg.chStore.loadExisting()) {
                    throw new IllegalStateException("Cannot load " + cg);
                }
            });
            return true;
        }
        return false;
    }

    private void checkIfConfiguredAndLoadedWeightingsCompatible() {
        String loadedStr = this.properties.get("graph.ch.profiles");
        List<String> loaded = Helper.parseList(loadedStr);
        List<CHConfig> configured = this.getCHConfigs();
        ArrayList<String> configuredNames = new ArrayList<String>(configured.size());
        for (CHConfig p : configured) {
            configuredNames.add(p.getName());
        }
        for (String configuredName : configuredNames) {
            if (loaded.contains(configuredName)) continue;
            throw new IllegalStateException("Configured CH profile: '" + configuredName + "' is not contained in loaded CH profiles: '" + loadedStr + "'.\nYou configured: " + configuredNames);
        }
    }

    public void flush() {
        this.chEntries.stream().map(ch -> ch.chStore).filter(s2 -> !s2.isClosed()).forEach(CHStorage::flush);
        this.baseGraph.flush();
        this.properties.flush();
    }

    @Override
    public void close() {
        this.properties.close();
        this.baseGraph.close();
        this.chEntries.stream().map(ch -> ch.chStore).filter(s2 -> !s2.isClosed()).forEach(CHStorage::close);
    }

    public boolean isClosed() {
        return this.baseGraph.nodes.isClosed();
    }

    public long getCapacity() {
        long cnt = this.baseGraph.getCapacity() + this.properties.getCapacity();
        long cgs = this.chEntries.stream().mapToLong(ch -> ch.chStore.getCapacity()).sum();
        return cnt + cgs;
    }

    public synchronized void freeze() {
        if (this.isFrozen()) {
            return;
        }
        this.baseGraph.freeze();
        this.chEntries.forEach(ch -> {
            double expectedShortcuts = 0.3 * (double)this.baseGraph.getEdges();
            ch.chStore.init(this.baseGraph.getNodes(), (int)expectedShortcuts);
        });
    }

    public boolean isFrozen() {
        return this.baseGraph.isFrozen();
    }

    public String toDetailsString() {
        String str = this.baseGraph.toDetailsString();
        for (CHEntry ch : this.chEntries) {
            str = str + ", " + ch.chStore.toDetailsString();
        }
        return str;
    }

    public String toString() {
        return (this.isCHPossible() ? "CH|" : "") + this.encodingManager + "|" + this.getDirectory().getDefaultType() + "|" + this.baseGraph.nodeAccess.getDimension() + "D|" + (this.baseGraph.supportsTurnCosts() ? this.baseGraph.turnCostStorage : "no_turn_cost") + "|" + this.getProperties().versionsToString();
    }

    @Override
    public Graph getBaseGraph() {
        return this.baseGraph;
    }

    @Override
    public int getNodes() {
        return this.baseGraph.getNodes();
    }

    @Override
    public int getEdges() {
        return this.baseGraph.getEdges();
    }

    @Override
    public NodeAccess getNodeAccess() {
        return this.baseGraph.getNodeAccess();
    }

    @Override
    public BBox getBounds() {
        return this.baseGraph.getBounds();
    }

    @Override
    public EdgeIteratorState edge(int a, int b) {
        return this.baseGraph.edge(a, b);
    }

    @Override
    public EdgeIteratorState getEdgeIteratorState(int edgeId, int adjNode) {
        return this.baseGraph.getEdgeIteratorState(edgeId, adjNode);
    }

    @Override
    public EdgeIteratorState getEdgeIteratorStateForKey(int edgeKey) {
        return this.baseGraph.getEdgeIteratorStateForKey(edgeKey);
    }

    @Override
    public AllEdgesIterator getAllEdges() {
        return this.baseGraph.getAllEdges();
    }

    @Override
    public EdgeExplorer createEdgeExplorer(EdgeFilter filter) {
        return this.baseGraph.createEdgeExplorer(filter);
    }

    @Override
    public TurnCostStorage getTurnCostStorage() {
        return this.baseGraph.getTurnCostStorage();
    }

    @Override
    public Weighting wrapWeighting(Weighting weighting) {
        return weighting;
    }

    @Override
    public int getOtherNode(int edge, int node) {
        return this.baseGraph.getOtherNode(edge, node);
    }

    @Override
    public boolean isAdjacentToNode(int edge, int node) {
        return this.baseGraph.isAdjacentToNode(edge, node);
    }

    public void flushAndCloseEarly() {
        this.baseGraph.flushAndCloseGeometryAndNameStorage();
    }

    private static class CHEntry {
        CHConfig chConfig;
        CHStorage chStore;
        RoutingCHGraphImpl chGraph;

        public CHEntry(CHConfig chConfig, CHStorage chStore, RoutingCHGraphImpl chGraph) {
            this.chConfig = chConfig;
            this.chStore = chStore;
            this.chGraph = chGraph;
        }
    }
}

