/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.Helper;

class GHNodeAccess
implements NodeAccess {
    private final BaseGraph baseGraph;
    private final boolean elevation;

    public GHNodeAccess(BaseGraph baseGraph, boolean withElevation) {
        this.baseGraph = baseGraph;
        this.elevation = withElevation;
    }

    @Override
    public void ensureNode(int nodeId) {
        this.baseGraph.ensureNodeIndex(nodeId);
    }

    @Override
    public final void setNode(int nodeId, double lat, double lon, double ele) {
        this.baseGraph.ensureNodeIndex(nodeId);
        long tmp = this.baseGraph.toNodePointer(nodeId);
        this.baseGraph.nodes.setInt(tmp + (long)this.baseGraph.N_LAT, Helper.degreeToInt(lat));
        this.baseGraph.nodes.setInt(tmp + (long)this.baseGraph.N_LON, Helper.degreeToInt(lon));
        if (this.is3D()) {
            this.baseGraph.nodes.setInt(tmp + (long)this.baseGraph.N_ELE, Helper.eleToInt(ele));
            this.baseGraph.bounds.update(lat, lon, ele);
        } else {
            this.baseGraph.bounds.update(lat, lon);
        }
    }

    @Override
    public final double getLat(int nodeId) {
        return Helper.intToDegree(this.baseGraph.nodes.getInt(this.baseGraph.toNodePointer(nodeId) + (long)this.baseGraph.N_LAT));
    }

    @Override
    public final double getLon(int nodeId) {
        return Helper.intToDegree(this.baseGraph.nodes.getInt(this.baseGraph.toNodePointer(nodeId) + (long)this.baseGraph.N_LON));
    }

    @Override
    public final double getEle(int nodeId) {
        if (!this.elevation) {
            throw new IllegalStateException("Cannot access elevation - 3D is not enabled");
        }
        return Helper.intToEle(this.baseGraph.nodes.getInt(this.baseGraph.toNodePointer(nodeId) + (long)this.baseGraph.N_ELE));
    }

    @Override
    public final void setTurnCostIndex(int index, int turnCostIndex) {
        if (!this.baseGraph.supportsTurnCosts()) {
            throw new AssertionError((Object)"This graph does not support turn costs");
        }
        this.baseGraph.ensureNodeIndex(index);
        long tmp = this.baseGraph.toNodePointer(index);
        this.baseGraph.nodes.setInt(tmp + (long)this.baseGraph.N_TC, turnCostIndex);
    }

    @Override
    public final int getTurnCostIndex(int index) {
        if (this.baseGraph.supportsTurnCosts()) {
            return this.baseGraph.nodes.getInt(this.baseGraph.toNodePointer(index) + (long)this.baseGraph.N_TC);
        }
        throw new AssertionError((Object)"This graph does not support turn costs");
    }

    @Override
    public final boolean is3D() {
        return this.elevation;
    }

    @Override
    public int getDimension() {
        if (this.elevation) {
            return 3;
        }
        return 2;
    }
}

