/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.graphhopper.routing.lm.LMConfig;
import com.graphhopper.routing.lm.LMRoutingAlgorithmFactory;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.lm.LandmarkSuggestion;
import com.graphhopper.routing.lm.SplitArea;
import com.graphhopper.routing.util.AbstractAlgoPreparation;
import com.graphhopper.routing.util.AreaIndex;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareLandmarks
extends AbstractAlgoPreparation {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrepareLandmarks.class);
    private final Graph graph;
    private final LandmarkStorage lms;
    private final LMConfig lmConfig;
    private long totalPrepareTime;

    public PrepareLandmarks(Directory dir, GraphHopperStorage graph, LMConfig lmConfig, int landmarks) {
        this.graph = graph;
        this.lmConfig = lmConfig;
        this.lms = new LandmarkStorage(graph, dir, lmConfig, landmarks);
    }

    public PrepareLandmarks setLandmarkSuggestions(List<LandmarkSuggestion> landmarkSuggestions) {
        this.lms.setLandmarkSuggestions(landmarkSuggestions);
        return this;
    }

    public PrepareLandmarks setAreaIndex(AreaIndex<SplitArea> areaIndex) {
        this.lms.setAreaIndex(areaIndex);
        return this;
    }

    public PrepareLandmarks setMaximumWeight(double maximumWeight) {
        this.lms.setMaximumWeight(maximumWeight);
        return this;
    }

    public void setLMSelectionWeighting(Weighting w) {
        this.lms.setLMSelectionWeighting(w);
    }

    public void setMinimumNodes(int nodes) {
        if (nodes < 2) {
            throw new IllegalArgumentException("minimum node count must be at least 2");
        }
        this.lms.setMinimumNodes(nodes);
    }

    public PrepareLandmarks setLogDetails(boolean logDetails) {
        this.lms.setLogDetails(logDetails);
        return this;
    }

    public LandmarkStorage getLandmarkStorage() {
        return this.lms;
    }

    public int getSubnetworksWithLandmarks() {
        return this.lms.getSubnetworksWithLandmarks();
    }

    public LMConfig getLMConfig() {
        return this.lmConfig;
    }

    public boolean loadExisting() {
        return this.lms.loadExisting();
    }

    @Override
    public void doSpecificWork() {
        StopWatch sw = new StopWatch().start();
        LOGGER.info("Start calculating " + this.lms.getLandmarkCount() + " landmarks, weighting:" + this.lms.getLmSelectionWeighting() + ", " + Helper.getMemInfo());
        this.lms.createLandmarks();
        this.lms.flush();
        LOGGER.info("Calculated landmarks for " + (this.lms.getSubnetworksWithLandmarks() - 1) + " subnetworks, took:" + (int)sw.stop().getSeconds() + "s => " + this.lms.getLandmarksAsGeoJSON() + ", stored weights:" + this.lms.getLandmarkCount() + ", nodes:" + this.graph.getNodes() + ", " + Helper.getMemInfo());
        this.totalPrepareTime = sw.getMillis();
    }

    public long getTotalPrepareTime() {
        return this.totalPrepareTime;
    }

    public LMRoutingAlgorithmFactory getRoutingAlgorithmFactory() {
        return new LMRoutingAlgorithmFactory(this.getLandmarkStorage());
    }

    void close() {
        this.lms.close();
    }
}

