/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.storage.DataAccess;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class HeightTile {
    private final int minLat;
    private final int minLon;
    private final int width;
    private final int height;
    private final int horizontalDegree;
    private final int verticalDegree;
    private final double lowerBound;
    private final double lonHigherBound;
    private final double latHigherBound;
    private DataAccess heights;
    private boolean interpolate;
    private final double MIN_ELEVATION_METERS = -12000.0;
    private final double MAX_ELEVATION_METERS = 9000.0;

    public HeightTile(int minLat, int minLon, int width, int height, double precision, int horizontalDegree, int verticalDegree) {
        this.minLat = minLat;
        this.minLon = minLon;
        this.width = width;
        this.height = height;
        this.lowerBound = -1.0 / precision;
        this.lonHigherBound = (double)horizontalDegree + 1.0 / precision;
        this.latHigherBound = (double)verticalDegree + 1.0 / precision;
        this.horizontalDegree = horizontalDegree;
        this.verticalDegree = verticalDegree;
    }

    public HeightTile setInterpolate(boolean interpolate) {
        this.interpolate = interpolate;
        return this;
    }

    public boolean isSeaLevel() {
        return this.heights.getHeader(0) == 1;
    }

    public HeightTile setSeaLevel(boolean b) {
        this.heights.setHeader(0, b ? 1 : 0);
        return this;
    }

    void setHeights(DataAccess da) {
        this.heights = da;
    }

    private short getHeightSample(int x, int y) {
        return this.heights.getShort(2 * (y * this.width + x));
    }

    private boolean isValidElevation(double elevation) {
        return elevation > -12000.0 && elevation < 9000.0;
    }

    private double linearInterpolate(double a, double b, double f) {
        return !this.isValidElevation(a) ? b : (!this.isValidElevation(b) ? a : a + (b - a) * f);
    }

    public double getHeight(double lat, double lon) {
        double elevation;
        double deltaLat = Math.abs(lat - (double)this.minLat);
        double deltaLon = Math.abs(lon - (double)this.minLon);
        if (deltaLat > this.latHigherBound || deltaLat < this.lowerBound) {
            throw new IllegalStateException("latitude not in boundary of this file:" + lat + "," + lon + ", this:" + this.toString());
        }
        if (deltaLon > this.lonHigherBound || deltaLon < this.lowerBound) {
            throw new IllegalStateException("longitude not in boundary of this file:" + lat + "," + lon + ", this:" + this.toString());
        }
        if (this.interpolate) {
            double x = (double)(this.width - 1) * deltaLon / (double)this.horizontalDegree;
            double y = (double)(this.height - 1) * (1.0 - deltaLat / (double)this.verticalDegree);
            int left = (int)x;
            int top = (int)y;
            int right = left + 1;
            int bottom = top + 1;
            double w00 = this.getHeightSample(left, top);
            double w01 = this.getHeightSample(left, bottom);
            double w10 = this.getHeightSample(right, top);
            double w11 = this.getHeightSample(right, bottom);
            double topEle = this.linearInterpolate(w00, w10, x - (double)left);
            double bottomEle = this.linearInterpolate(w01, w11, x - (double)left);
            elevation = this.linearInterpolate(topEle, bottomEle, y - (double)top);
        } else {
            int y;
            int x = (int)((double)(this.width / this.horizontalDegree) * deltaLon);
            if (x >= this.width) {
                x = this.width - 1;
            }
            if ((y = this.height - 1 - (int)((double)(this.height / this.verticalDegree) * deltaLat)) < 0) {
                y = 0;
            }
            elevation = this.getHeightSample(x, y);
        }
        return this.isValidElevation(elevation) ? elevation : Double.NaN;
    }

    public void toImage(String imageFile) throws IOException {
        ImageIO.write((RenderedImage)this.makeARGB(), "PNG", new File(imageFile));
    }

    protected BufferedImage makeARGB() {
        BufferedImage argbImage = new BufferedImage(this.width, this.height, 2);
        Graphics g2 = argbImage.getGraphics();
        long len = this.width * this.height;
        int i = 0;
        while ((long)i < len) {
            int lonSimilar = i % this.width;
            int latSimilar = i / this.height;
            int green = Math.abs(this.heights.getShort(i * 2));
            if (green == 0) {
                g2.setColor(new Color(255, 0, 0, 255));
            } else {
                int red = 0;
                while (green > 255) {
                    green /= 10;
                    red += 50;
                }
                if (red > 255) {
                    red = 255;
                }
                g2.setColor(new Color(red, green, 122, 255));
            }
            g2.drawLine(lonSimilar, latSimilar, lonSimilar, latSimilar);
            ++i;
        }
        g2.dispose();
        return argbImage;
    }

    public BufferedImage getImageFromArray(int[] pixels, int width, int height) {
        BufferedImage tmpImage = new BufferedImage(width, height, 3);
        tmpImage.setRGB(0, 0, width, height, pixels, 0, width);
        return tmpImage;
    }

    public String toString() {
        return this.minLat + "," + this.minLon;
    }
}

