/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.json;

public class Statement {
    private final Keyword keyword;
    private final String condition;
    private final Op operation;
    private final double value;

    private Statement(Keyword keyword, String condition, Op operation, double value) {
        this.keyword = keyword;
        this.condition = condition;
        this.value = value;
        this.operation = operation;
    }

    public Keyword getKeyword() {
        return this.keyword;
    }

    public String getCondition() {
        return this.condition;
    }

    public Op getOperation() {
        return this.operation;
    }

    public double getValue() {
        return this.value;
    }

    public double apply(double externValue) {
        switch (this.operation) {
            case MULTIPLY: {
                return this.value * externValue;
            }
            case LIMIT: {
                return Math.min(this.value, externValue);
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return "{" + this.str(this.keyword.getName()) + ": " + this.str(this.condition) + ", " + this.str(this.operation.getName()) + ": " + this.value + "}";
    }

    private String str(String str) {
        return "\"" + str + "\"";
    }

    public static Statement If(String expression, Op op, double value) {
        return new Statement(Keyword.IF, expression, op, value);
    }

    public static Statement ElseIf(String expression, Op op, double value) {
        return new Statement(Keyword.ELSEIF, expression, op, value);
    }

    public static Statement Else(Op op, double value) {
        return new Statement(Keyword.ELSE, null, op, value);
    }

    public static enum Op {
        MULTIPLY("multiply_by"),
        LIMIT("limit_to");

        String name;

        private Op(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String build(double value) {
            switch (this) {
                case MULTIPLY: {
                    return "value *= " + value;
                }
                case LIMIT: {
                    return "value = Math.min(value," + value + ")";
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public static enum Keyword {
        IF("if"),
        ELSEIF("else_if"),
        ELSE("else");

        String name;

        private Keyword(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

