/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http.cli;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.ResponsePath;
import com.graphhopper.gpx.GpxConversions;
import com.graphhopper.http.GraphHopperServerConfiguration;
import com.graphhopper.jackson.Gpx;
import com.graphhopper.matching.MapMatching;
import com.graphhopper.matching.MatchResult;
import com.graphhopper.matching.Observation;
import com.graphhopper.util.Constants;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.Translation;
import com.graphhopper.util.TranslationMap;
import io.dropwizard.cli.ConfiguredCommand;
import io.dropwizard.setup.Bootstrap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class MatchCommand
extends ConfiguredCommand<GraphHopperServerConfiguration> {
    public MatchCommand() {
        super("match", "map-match one or more gpx files");
    }

    @Override
    public void configure(Subparser subparser) {
        subparser.addArgument("gpx").type(File.class).required(true).nargs("+").help("GPX file");
        subparser.addArgument("--file").required(true).help("application configuration file");
        subparser.addArgument("--profile").type(String.class).required(true).help("profile to use for map-matching (must be configured in configuration file)");
        subparser.addArgument("--instructions").type(String.class).required(false).setDefault("").help("Locale for instructions");
        subparser.addArgument("--gps_accuracy").type(Integer.class).required(false).setDefault((Object)40);
        subparser.addArgument("--transition_probability_beta").type(Double.class).required(false).setDefault((Object)2.0);
    }

    @Override
    protected Argument addFileArgument(Subparser subparser) {
        throw new RuntimeException();
    }

    @Override
    protected void run(Bootstrap<GraphHopperServerConfiguration> bootstrap, Namespace args, GraphHopperServerConfiguration configuration) {
        GraphHopperConfig graphHopperConfiguration = configuration.getGraphHopperConfiguration();
        GraphHopper hopper = new GraphHopper().init(graphHopperConfiguration);
        hopper.importOrLoad();
        PMap hints = new PMap();
        hints.putObject("profile", args.get("profile"));
        MapMatching mapMatching = new MapMatching(hopper, hints);
        mapMatching.setTransitionProbabilityBeta(args.getDouble("transition_probability_beta"));
        mapMatching.setMeasurementErrorSigma(args.getInt("gps_accuracy").intValue());
        StopWatch importSW = new StopWatch();
        StopWatch matchSW = new StopWatch();
        Translation tr = new TranslationMap().doImport().getWithFallBack(Helper.getLocale(args.getString("instructions")));
        boolean withRoute = !args.getString("instructions").isEmpty();
        XmlMapper xmlMapper = new XmlMapper();
        for (File gpxFile : args.getList("gpx")) {
            try {
                importSW.start();
                Gpx gpx = xmlMapper.readValue(gpxFile, Gpx.class);
                if (gpx.trk == null) {
                    throw new IllegalArgumentException("No tracks found in GPX document. Are you using waypoints or routes instead?");
                }
                if (gpx.trk.size() > 1) {
                    throw new IllegalArgumentException("GPX documents with multiple tracks not supported yet.");
                }
                List<Observation> measurements = GpxConversions.getEntries(gpx.trk.get(0));
                importSW.stop();
                matchSW.start();
                MatchResult mr = mapMatching.match(measurements);
                matchSW.stop();
                System.out.println(gpxFile);
                System.out.println("\tmatches:\t" + mr.getEdgeMatches().size() + ", gps entries:" + measurements.size());
                System.out.println("\tgpx length:\t" + (float)mr.getGpxEntriesLength() + " vs " + (float)mr.getMatchLength());
                String outFile = gpxFile.getAbsolutePath() + ".res.gpx";
                System.out.println("\texport results to:" + outFile);
                ResponsePath responsePath = new PathMerger(mr.getGraph(), mr.getWeighting()).doWork(PointList.EMPTY, Collections.singletonList(mr.getMergedPath()), hopper.getEncodingManager(), tr);
                if (responsePath.hasErrors()) {
                    System.err.println("Problem with file " + gpxFile + ", " + responsePath.getErrors());
                    continue;
                }
                BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
                Throwable throwable = null;
                try {
                    long time = gpx.trk.get(0).getStartTime().map(Date::getTime).orElse(System.currentTimeMillis());
                    writer.append(GpxConversions.createGPX(responsePath.getInstructions(), gpx.trk.get((int)0).name != null ? gpx.trk.get((int)0).name : "", time, hopper.hasElevation(), withRoute, true, false, Constants.VERSION, tr));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (Exception ex) {
                importSW.stop();
                matchSW.stop();
                System.err.println("Problem with file " + gpxFile);
                ex.printStackTrace(System.err);
            }
        }
        System.out.println("gps import took:" + importSW.getSeconds() + "s, match took: " + matchSW.getSeconds());
    }
}

