/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.Label;
import com.graphhopper.gtfs.PtEncodedValues;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.util.AccessFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class GraphExplorer {
    private final EdgeExplorer edgeExplorer;
    private final PtEncodedValues flagEncoder;
    private final EnumEncodedValue<GtfsStorage.EdgeType> typeEnc;
    private final GtfsStorage gtfsStorage;
    private final RealtimeFeed realtimeFeed;
    private final boolean reverse;
    private final Weighting accessEgressWeighting;
    private final BooleanEncodedValue accessEnc;
    private final boolean walkOnly;
    private final boolean ptOnly;
    private final double walkSpeedKmH;
    private final boolean ignoreValidities;
    private final IntEncodedValue validityEnc;
    private final int blockedRouteTypes;
    private final Graph graph;

    public GraphExplorer(Graph graph, Weighting accessEgressWeighting, PtEncodedValues flagEncoder, GtfsStorage gtfsStorage, RealtimeFeed realtimeFeed, boolean reverse, boolean walkOnly, boolean ptOnly, double walkSpeedKmh, boolean ignoreValidities, int blockedRouteTypes) {
        this.graph = graph;
        this.accessEgressWeighting = accessEgressWeighting;
        this.accessEnc = accessEgressWeighting.getFlagEncoder().getAccessEnc();
        this.ignoreValidities = ignoreValidities;
        this.blockedRouteTypes = blockedRouteTypes;
        AccessFilter accessEgressIn = AccessFilter.inEdges(accessEgressWeighting.getFlagEncoder().getAccessEnc());
        AccessFilter accessEgressOut = AccessFilter.outEdges(accessEgressWeighting.getFlagEncoder().getAccessEnc());
        AccessFilter ptIn = AccessFilter.inEdges(flagEncoder.getAccessEnc());
        AccessFilter ptOut = AccessFilter.outEdges(flagEncoder.getAccessEnc());
        EdgeFilter in = edgeState -> accessEgressIn.accept(edgeState) || ptIn.accept(edgeState);
        EdgeFilter out = edgeState -> accessEgressOut.accept(edgeState) || ptOut.accept(edgeState);
        this.edgeExplorer = graph.createEdgeExplorer(reverse ? in : out);
        this.flagEncoder = flagEncoder;
        this.typeEnc = flagEncoder.getTypeEnc();
        this.validityEnc = flagEncoder.getValidityIdEnc();
        this.gtfsStorage = gtfsStorage;
        this.realtimeFeed = realtimeFeed;
        this.reverse = reverse;
        this.walkOnly = walkOnly;
        this.ptOnly = ptOnly;
        this.walkSpeedKmH = walkSpeedKmh;
    }

    Stream<EdgeIteratorState> exploreEdgesAround(final Label label) {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<EdgeIteratorState>(0L, 0){
            final EdgeIterator edgeIterator;
            {
                super(x0, x1);
                this.edgeIterator = GraphExplorer.this.edgeExplorer.setBaseNode(label.adjNode);
            }

            @Override
            public boolean tryAdvance(Consumer<? super EdgeIteratorState> action) {
                while (this.edgeIterator.next()) {
                    GtfsStorage.EdgeType edgeType = (GtfsStorage.EdgeType)((Object)this.edgeIterator.get(GraphExplorer.this.typeEnc));
                    if (edgeType == GtfsStorage.EdgeType.ENTER_TIME_EXPANDED_NETWORK) {
                        if (GraphExplorer.this.walkOnly) {
                            return false;
                        }
                        action.accept(this.findEnterEdge());
                        return true;
                    }
                    if (edgeType == GtfsStorage.EdgeType.HIGHWAY) {
                        if (!(GraphExplorer.this.reverse ? this.edgeIterator.getReverse(GraphExplorer.this.accessEnc) : this.edgeIterator.get(GraphExplorer.this.accessEnc))) continue;
                        action.accept(this.edgeIterator);
                        return true;
                    }
                    if (GraphExplorer.this.walkOnly && edgeType != (GraphExplorer.this.reverse ? GtfsStorage.EdgeType.EXIT_PT : GtfsStorage.EdgeType.ENTER_PT) || !GraphExplorer.this.ignoreValidities && !GraphExplorer.this.isValidOn(this.edgeIterator, label.currentTime) || edgeType == GtfsStorage.EdgeType.WAIT_ARRIVAL && !GraphExplorer.this.reverse || edgeType == GtfsStorage.EdgeType.ENTER_PT && GraphExplorer.this.reverse && GraphExplorer.this.ptOnly || edgeType == GtfsStorage.EdgeType.EXIT_PT && !GraphExplorer.this.reverse && GraphExplorer.this.ptOnly || (edgeType == GtfsStorage.EdgeType.ENTER_PT || edgeType == GtfsStorage.EdgeType.EXIT_PT) && (GraphExplorer.this.blockedRouteTypes & 1 << this.edgeIterator.get(GraphExplorer.this.validityEnc)) != 0 || edgeType == GtfsStorage.EdgeType.ENTER_PT && this.justExitedPt(label)) continue;
                    action.accept(this.edgeIterator);
                    return true;
                }
                return false;
            }

            private boolean justExitedPt(Label label2) {
                if (label2.edge == -1) {
                    return false;
                }
                EdgeIteratorState edgeIteratorState = GraphExplorer.this.graph.getEdgeIteratorState(label2.edge, label2.adjNode);
                GtfsStorage.EdgeType edgeType = (GtfsStorage.EdgeType)((Object)edgeIteratorState.get(GraphExplorer.this.typeEnc));
                return edgeType == GtfsStorage.EdgeType.EXIT_PT;
            }

            private EdgeIteratorState findEnterEdge() {
                EdgeIteratorState first = this.edgeIterator.detach(false);
                long firstTT = GraphExplorer.this.calcTravelTimeMillis(this.edgeIterator, label.currentTime);
                while (this.edgeIterator.next()) {
                    long nextTT = GraphExplorer.this.calcTravelTimeMillis(this.edgeIterator, label.currentTime);
                    if (nextTT >= firstTT) continue;
                    EdgeIteratorState result = this.edgeIterator.detach(false);
                    while (this.edgeIterator.next()) {
                    }
                    return result;
                }
                return first;
            }
        }, false);
    }

    long calcTravelTimeMillis(EdgeIteratorState edge, long earliestStartTime) {
        switch (edge.get(this.typeEnc)) {
            case HIGHWAY: {
                return (long)((double)this.accessEgressWeighting.calcEdgeMillis(edge, this.reverse) * (5.0 / this.walkSpeedKmH));
            }
            case ENTER_TIME_EXPANDED_NETWORK: {
                if (this.reverse) {
                    return 0L;
                }
                return this.waitingTime(edge, earliestStartTime);
            }
            case LEAVE_TIME_EXPANDED_NETWORK: {
                if (this.reverse) {
                    return -this.waitingTime(edge, earliestStartTime);
                }
                return 0L;
            }
        }
        return edge.get(this.flagEncoder.getTimeEnc()) * 1000;
    }

    boolean isBlocked(EdgeIteratorState edge) {
        return this.realtimeFeed.isBlocked(edge.getEdge());
    }

    long getDelayFromBoardEdge(EdgeIteratorState edge, long currentTime) {
        return this.realtimeFeed.getDelayForBoardEdge(edge, Instant.ofEpochMilli(currentTime));
    }

    long getDelayFromAlightEdge(EdgeIteratorState edge, long currentTime) {
        return this.realtimeFeed.getDelayForAlightEdge(edge, Instant.ofEpochMilli(currentTime));
    }

    private long waitingTime(EdgeIteratorState edge, long earliestStartTime) {
        long l = (long)(edge.get(this.flagEncoder.getTimeEnc()) * 1000) - this.millisOnTravelDay(edge, earliestStartTime);
        if (!this.reverse) {
            if (l < 0L) {
                l += 86400000L;
            }
        } else if (l > 0L) {
            l -= 86400000L;
        }
        return l;
    }

    private long millisOnTravelDay(EdgeIteratorState edge, long instant) {
        ZoneId zoneId = this.gtfsStorage.getTimeZones().get((Object)Integer.valueOf((int)edge.get((IntEncodedValue)this.flagEncoder.getValidityIdEnc()))).zoneId;
        return Instant.ofEpochMilli(instant).atZone(zoneId).toLocalTime().toNanoOfDay() / 1000000L;
    }

    private boolean isValidOn(EdgeIteratorState edge, long instant) {
        GtfsStorage.EdgeType edgeType = edge.get(this.typeEnc);
        if (edgeType == GtfsStorage.EdgeType.BOARD || edgeType == GtfsStorage.EdgeType.ALIGHT) {
            int validityId = edge.get(this.validityEnc);
            GtfsStorage.Validity validity = this.realtimeFeed.getValidity(validityId);
            int trafficDay = (int)ChronoUnit.DAYS.between(validity.start, Instant.ofEpochMilli(instant).atZone(validity.zoneId).toLocalDate());
            return trafficDay >= 0 && validity.validity.get(trafficDay);
        }
        return true;
    }

    int calcNTransfers(EdgeIteratorState edge) {
        return edge.get(this.flagEncoder.getTransfersEnc());
    }
}

