/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.validation.selfvalidating;

import io.dropwizard.validation.InterpolationHelper;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;

public class ViolationCollector {
    private final ConstraintValidatorContext constraintValidatorContext;
    private final boolean escapeExpressions;
    private boolean violationOccurred = false;

    public ViolationCollector(ConstraintValidatorContext constraintValidatorContext) {
        this(constraintValidatorContext, true);
    }

    public ViolationCollector(ConstraintValidatorContext constraintValidatorContext, boolean escapeExpressions) {
        this.constraintValidatorContext = constraintValidatorContext;
        this.escapeExpressions = escapeExpressions;
    }

    public void addViolation(String message) {
        this.addViolation(message, Collections.emptyMap());
    }

    public void addViolation(String message, Map<String, Object> messageParameters) {
        this.violationOccurred = true;
        this.getContextWithMessageParameters(messageParameters).buildConstraintViolationWithTemplate(this.sanitizeTemplate(message)).addConstraintViolation();
    }

    public void addViolation(String propertyName, String message) {
        this.addViolation(propertyName, message, Collections.emptyMap());
    }

    public void addViolation(String propertyName, String message, Map<String, Object> messageParameters) {
        this.violationOccurred = true;
        this.getContextWithMessageParameters(messageParameters).buildConstraintViolationWithTemplate(this.sanitizeTemplate(message)).addPropertyNode(propertyName).addConstraintViolation();
    }

    public void addViolation(String propertyName, Integer index, String message) {
        this.addViolation(propertyName, index, message, Collections.emptyMap());
    }

    public void addViolation(String propertyName, Integer index, String message, Map<String, Object> messageParameters) {
        this.violationOccurred = true;
        this.getContextWithMessageParameters(messageParameters).buildConstraintViolationWithTemplate(this.sanitizeTemplate(message)).addPropertyNode(propertyName).addBeanNode().inIterable().atIndex(index).addConstraintViolation();
    }

    public void addViolation(String propertyName, String key, String message) {
        this.addViolation(propertyName, key, message, Collections.emptyMap());
    }

    public void addViolation(String propertyName, String key, String message, Map<String, Object> messageParameters) {
        this.violationOccurred = true;
        String messageTemplate = this.sanitizeTemplate(message);
        HibernateConstraintValidatorContext context = this.getContextWithMessageParameters(messageParameters);
        context.buildConstraintViolationWithTemplate(messageTemplate).addPropertyNode(propertyName).addBeanNode().inIterable().atKey(key).addConstraintViolation();
    }

    private HibernateConstraintValidatorContext getContextWithMessageParameters(Map<String, Object> messageParameters) {
        HibernateConstraintValidatorContext context = this.constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class);
        for (Map.Entry<String, Object> messageParameter : messageParameters.entrySet()) {
            Object value = messageParameter.getValue();
            String escapedValue = value == null ? null : InterpolationHelper.escapeMessageParameter(value.toString());
            context.addMessageParameter(messageParameter.getKey(), escapedValue);
        }
        return context;
    }

    @Nullable
    private String sanitizeTemplate(@Nullable String message) {
        return this.escapeExpressions ? InterpolationHelper.escapeMessageParameter(message) : message;
    }

    public ConstraintValidatorContext getContext() {
        return this.constraintValidatorContext;
    }

    public boolean hasViolationOccurred() {
        return this.violationOccurred;
    }

    public void setViolationOccurred(boolean violationOccurred) {
        this.violationOccurred = violationOccurred;
    }
}

