/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.json.Statement;
import com.graphhopper.util.JsonFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CustomModel {
    public static final String KEY = "custom_model";
    static double DEFAULT_DISTANCE_INFLUENCE = 70.0;
    private Double distanceInfluence;
    private double headingPenalty = 300.0;
    private boolean internal;
    private List<Statement> speedStatements = new ArrayList<Statement>();
    private List<Statement> priorityStatements = new ArrayList<Statement>();
    private Map<String, JsonFeature> areas = new HashMap<String, JsonFeature>();

    public CustomModel() {
    }

    public CustomModel(CustomModel toCopy) {
        this.headingPenalty = toCopy.headingPenalty;
        this.distanceInfluence = toCopy.distanceInfluence;
        this.speedStatements = this.deepCopy(toCopy.getSpeed());
        this.priorityStatements = this.deepCopy(toCopy.getPriority());
        this.areas.putAll(toCopy.getAreas());
    }

    public CustomModel internal() {
        this.internal = true;
        return this;
    }

    public boolean isInternal() {
        return this.internal;
    }

    private <T> T deepCopy(T originalObject) {
        if (originalObject instanceof List) {
            ArrayList newList = new ArrayList(((List)originalObject).size());
            for (Object item : (List)originalObject) {
                newList.add(this.deepCopy(item));
            }
            return (T)newList;
        }
        if (originalObject instanceof Map) {
            HashMap copy = originalObject instanceof LinkedHashMap ? new LinkedHashMap(((Map)originalObject).size()) : new HashMap(((Map)originalObject).size());
            Iterator iterator = ((Map)originalObject).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                copy.put(entry.getKey(), this.deepCopy(entry.getValue()));
            }
            return (T)copy;
        }
        return originalObject;
    }

    public List<Statement> getSpeed() {
        return this.speedStatements;
    }

    public CustomModel addToSpeed(Statement st) {
        this.getSpeed().add(st);
        return this;
    }

    public List<Statement> getPriority() {
        return this.priorityStatements;
    }

    public CustomModel addToPriority(Statement st) {
        this.getPriority().add(st);
        return this;
    }

    public CustomModel setAreas(Map<String, JsonFeature> areas) {
        this.areas = areas;
        return this;
    }

    public Map<String, JsonFeature> getAreas() {
        return this.areas;
    }

    public CustomModel setDistanceInfluence(double distanceFactor) {
        this.distanceInfluence = distanceFactor;
        return this;
    }

    public double getDistanceInfluence() {
        return this.distanceInfluence == null ? DEFAULT_DISTANCE_INFLUENCE : this.distanceInfluence;
    }

    public void setHeadingPenalty(double headingPenalty) {
        this.headingPenalty = headingPenalty;
    }

    public double getHeadingPenalty() {
        return this.headingPenalty;
    }

    public String toString() {
        return this.createContentString();
    }

    private String createContentString() {
        return "distanceInfluence=" + this.distanceInfluence + "|headingPenalty=" + this.headingPenalty + "|speedStatements=" + this.speedStatements + "|priorityStatements=" + this.priorityStatements + "|areas=" + this.areas;
    }

    public void checkLMConstraints(CustomModel baseModel) {
        if (this.isInternal()) {
            throw new IllegalArgumentException("CustomModel of query cannot be internal");
        }
        if (this.distanceInfluence != null && this.distanceInfluence < baseModel.getDistanceInfluence()) {
            throw new IllegalArgumentException("CustomModel in query can only use distance_influence bigger or equal to " + baseModel.getDistanceInfluence() + ", given: " + this.distanceInfluence);
        }
        CustomModel.checkMultiplyValue(this.getPriority());
        double maxPrio = this.findMaxPriority(1.0);
        if (maxPrio > 1.0) {
            throw new IllegalArgumentException("priority of CustomModel in query cannot be bigger than 1. Was: " + maxPrio);
        }
        CustomModel.checkMultiplyValue(this.getSpeed());
    }

    private static void checkMultiplyValue(List<Statement> list) {
        for (Statement statement : list) {
            if (statement.getOperation() != Statement.Op.MULTIPLY || !(statement.getValue() > 1.0)) continue;
            throw new IllegalArgumentException("factor cannot be larger than 1 but was " + statement.getValue());
        }
    }

    static double findMax(List<Statement> statements, double max, String type) {
        List<List<Statement>> blocks = CustomModel.splitIntoBlocks(statements);
        for (List<Statement> block : blocks) {
            max = CustomModel.findMaxForBlock(block, max);
        }
        if (max <= 0.0) {
            throw new IllegalArgumentException(type + " cannot be negative or 0");
        }
        return max;
    }

    public double findMaxPriority(double maxPriority) {
        return CustomModel.findMax(this.getPriority(), maxPriority, "priority");
    }

    public double findMaxSpeed(double maxSpeed) {
        return CustomModel.findMax(this.getSpeed(), maxSpeed, "vehicle speed");
    }

    static double findMaxForBlock(List<Statement> block, double max) {
        if (block.isEmpty() || !Statement.Keyword.IF.equals((Object)block.get(0).getKeyword())) {
            throw new IllegalArgumentException("Every block must start with an if-statement");
        }
        if (block.get(0).getCondition().trim().equals("true")) {
            return block.get(0).apply(max);
        }
        double blockMax = block.stream().mapToDouble(statement -> statement.apply(max)).max().orElse(max);
        if (block.stream().noneMatch(st -> Statement.Keyword.ELSE.equals((Object)st.getKeyword()))) {
            blockMax = Math.max(blockMax, max);
        }
        return blockMax;
    }

    static List<List<Statement>> splitIntoBlocks(List<Statement> statements) {
        ArrayList<List<Statement>> result = new ArrayList<List<Statement>>();
        ArrayList<Statement> block = null;
        for (Statement st : statements) {
            if (Statement.Keyword.IF.equals((Object)st.getKeyword())) {
                block = new ArrayList<Statement>();
                result.add(block);
            }
            if (block == null) {
                throw new IllegalArgumentException("Every block must start with an if-statement");
            }
            block.add(st);
        }
        return result;
    }

    public static CustomModel merge(CustomModel baseModel, CustomModel queryModel) {
        if (queryModel == null) {
            return baseModel;
        }
        CustomModel mergedCM = new CustomModel(baseModel);
        if (queryModel.distanceInfluence != null) {
            mergedCM.distanceInfluence = queryModel.distanceInfluence;
        }
        mergedCM.speedStatements.addAll(queryModel.getSpeed());
        mergedCM.priorityStatements.addAll(queryModel.getPriority());
        for (Map.Entry<String, JsonFeature> entry : queryModel.getAreas().entrySet()) {
            if (mergedCM.areas.containsKey(entry.getKey())) {
                throw new IllegalArgumentException("area " + entry.getKey() + " already exists");
            }
            mergedCM.areas.put(entry.getKey(), entry.getValue());
        }
        return mergedCM;
    }
}

