/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;

public class QueryGraphWeighting
implements Weighting {
    private final Weighting weighting;
    private final int firstVirtualNodeId;
    private final int firstVirtualEdgeId;
    private final IntArrayList closestEdges;

    public QueryGraphWeighting(Weighting weighting, int firstVirtualNodeId, int firstVirtualEdgeId, IntArrayList closestEdges) {
        this.weighting = weighting;
        this.firstVirtualNodeId = firstVirtualNodeId;
        this.firstVirtualEdgeId = firstVirtualEdgeId;
        this.closestEdges = closestEdges;
    }

    @Override
    public double getMinWeight(double distance) {
        return this.weighting.getMinWeight(distance);
    }

    @Override
    public double calcEdgeWeight(EdgeIteratorState edgeState, boolean reverse) {
        return this.weighting.calcEdgeWeight(edgeState, reverse);
    }

    @Override
    public double calcTurnWeight(int inEdge, int viaNode, int outEdge) {
        if (!EdgeIterator.Edge.isValid(inEdge) || !EdgeIterator.Edge.isValid(outEdge)) {
            return 0.0;
        }
        if (this.isVirtualNode(viaNode)) {
            if (this.isUTurn(inEdge, outEdge)) {
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        if (this.isVirtualEdge(inEdge)) {
            inEdge = this.getOriginalEdge(inEdge);
        }
        if (this.isVirtualEdge(outEdge)) {
            outEdge = this.getOriginalEdge(outEdge);
        }
        return this.weighting.calcTurnWeight(inEdge, viaNode, outEdge);
    }

    private boolean isUTurn(int inEdge, int outEdge) {
        return inEdge == outEdge;
    }

    @Override
    public long calcEdgeMillis(EdgeIteratorState edgeState, boolean reverse) {
        return this.weighting.calcEdgeMillis(edgeState, reverse);
    }

    @Override
    public long calcTurnMillis(int inEdge, int viaNode, int outEdge) {
        return (long)(1000.0 * this.calcTurnWeight(inEdge, viaNode, outEdge));
    }

    @Override
    public boolean hasTurnCosts() {
        return this.weighting.hasTurnCosts();
    }

    @Override
    public FlagEncoder getFlagEncoder() {
        return this.weighting.getFlagEncoder();
    }

    @Override
    public String getName() {
        return this.weighting.getName();
    }

    public String toString() {
        return this.getName();
    }

    private int getOriginalEdge(int edge) {
        return this.closestEdges.get((edge - this.firstVirtualEdgeId) / 2);
    }

    private boolean isVirtualNode(int node) {
        return node >= this.firstVirtualNodeId;
    }

    private boolean isVirtualEdge(int edge) {
        return edge >= this.firstVirtualEdgeId;
    }
}

