/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.spatialrules.SpatialRuleSet;
import com.graphhopper.storage.IntsRef;
import java.util.Arrays;
import java.util.List;

public class OSMRoadAccessParser
implements TagParser {
    protected final EnumEncodedValue<RoadAccess> roadAccessEnc;
    private final List<String> restrictions;

    public OSMRoadAccessParser() {
        this(new EnumEncodedValue<RoadAccess>("road_access", RoadAccess.class), OSMRoadAccessParser.toOSMRestrictions(TransportationMode.CAR));
    }

    public OSMRoadAccessParser(EnumEncodedValue<RoadAccess> roadAccessEnc, List<String> restrictions) {
        this.roadAccessEnc = roadAccessEnc;
        this.restrictions = restrictions;
    }

    @Override
    public void createEncodedValues(EncodedValueLookup lookup, List<EncodedValue> list) {
        list.add(this.roadAccessEnc);
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay readerWay, boolean ferry, IntsRef relationFlags) {
        RoadAccess accessValue = RoadAccess.YES;
        for (String restriction : this.restrictions) {
            RoadAccess tmpAccessValue = RoadAccess.find(readerWay.getTag(restriction, "yes"));
            if (tmpAccessValue == null || tmpAccessValue.ordinal() <= accessValue.ordinal()) continue;
            accessValue = tmpAccessValue;
        }
        SpatialRuleSet spatialRuleSet = readerWay.getTag("spatial_rule_set", null);
        if (spatialRuleSet != null && spatialRuleSet != SpatialRuleSet.EMPTY) {
            RoadClass roadClass = RoadClass.find(readerWay.getTag("highway", ""));
            accessValue = spatialRuleSet.getAccess(roadClass, TransportationMode.CAR, RoadAccess.YES);
        }
        this.roadAccessEnc.setEnum(false, edgeFlags, accessValue);
        return edgeFlags;
    }

    public static List<String> toOSMRestrictions(TransportationMode mode) {
        switch (mode) {
            case FOOT: {
                return Arrays.asList("foot", "access");
            }
            case VEHICLE: {
                return Arrays.asList("vehicle", "access");
            }
            case BIKE: {
                return Arrays.asList("bicycle", "vehicle", "access");
            }
            case CAR: {
                return Arrays.asList("motorcar", "motor_vehicle", "vehicle", "access");
            }
            case MOTORCYCLE: {
                return Arrays.asList("motorcycle", "motor_vehicle", "vehicle", "access");
            }
            case HGV: {
                return Arrays.asList("hgv", "motor_vehicle", "vehicle", "access");
            }
            case PSV: {
                return Arrays.asList("psv", "motor_vehicle", "vehicle", "access");
            }
        }
        throw new IllegalArgumentException("Cannot convert TransportationMode " + (Object)((Object)mode) + " to list of restrictions");
    }
}

