/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.UnsignedDecimalEncodedValue;
import com.graphhopper.routing.util.AbstractFlagEncoder;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.PMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class FootFlagEncoder
extends AbstractFlagEncoder {
    static final int SLOW_SPEED = 2;
    static final int MEAN_SPEED = 5;
    static final int FERRY_SPEED = 15;
    final Set<String> safeHighwayTags = new HashSet<String>();
    final Set<String> allowedHighwayTags = new HashSet<String>();
    final Set<String> avoidHighwayTags = new HashSet<String>();
    final Set<String> allowedSacScale = new HashSet<String>();
    protected HashSet<String> sidewalkValues = new HashSet(5);
    protected HashSet<String> sidewalksNoValues = new HashSet(5);
    protected boolean speedTwoDirections;
    private DecimalEncodedValue priorityWayEncoder;
    private EnumEncodedValue<RouteNetwork> footRouteEnc;
    Map<RouteNetwork, Integer> routeMap = new HashMap<RouteNetwork, Integer>();

    public FootFlagEncoder() {
        this(4, 1.0);
    }

    public FootFlagEncoder(PMap properties) {
        this(properties.getInt("speed_bits", 4), properties.getDouble("speed_factor", 1.0));
        this.blockPrivate(properties.getBool("block_private", true));
        this.blockFords(properties.getBool("block_fords", false));
        this.blockBarriersByDefault(properties.getBool("block_barriers", false));
        this.speedTwoDirections = properties.getBool("speed_two_directions", false);
    }

    protected FootFlagEncoder(int speedBits, double speedFactor) {
        super(speedBits, speedFactor, 0);
        this.restrictedValues.add("no");
        this.restrictedValues.add("restricted");
        this.restrictedValues.add("military");
        this.restrictedValues.add("emergency");
        this.restrictedValues.add("private");
        this.intendedValues.add("yes");
        this.intendedValues.add("designated");
        this.intendedValues.add("official");
        this.intendedValues.add("permissive");
        this.sidewalksNoValues.add("no");
        this.sidewalksNoValues.add("none");
        this.sidewalksNoValues.add("separate");
        this.sidewalkValues.add("yes");
        this.sidewalkValues.add("both");
        this.sidewalkValues.add("left");
        this.sidewalkValues.add("right");
        this.blockBarriersByDefault(false);
        this.absoluteBarriers.add("fence");
        this.potentialBarriers.add("gate");
        this.potentialBarriers.add("cattle_grid");
        this.potentialBarriers.add("chain");
        this.safeHighwayTags.add("footway");
        this.safeHighwayTags.add("path");
        this.safeHighwayTags.add("steps");
        this.safeHighwayTags.add("pedestrian");
        this.safeHighwayTags.add("living_street");
        this.safeHighwayTags.add("track");
        this.safeHighwayTags.add("residential");
        this.safeHighwayTags.add("service");
        this.safeHighwayTags.add("platform");
        this.avoidHighwayTags.add("trunk");
        this.avoidHighwayTags.add("trunk_link");
        this.avoidHighwayTags.add("primary");
        this.avoidHighwayTags.add("primary_link");
        this.avoidHighwayTags.add("secondary");
        this.avoidHighwayTags.add("secondary_link");
        this.avoidHighwayTags.add("tertiary");
        this.avoidHighwayTags.add("tertiary_link");
        this.allowedHighwayTags.addAll(this.safeHighwayTags);
        this.allowedHighwayTags.addAll(this.avoidHighwayTags);
        this.allowedHighwayTags.add("cycleway");
        this.allowedHighwayTags.add("unclassified");
        this.allowedHighwayTags.add("road");
        this.routeMap.put(RouteNetwork.INTERNATIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.NATIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.REGIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.LOCAL, PriorityCode.UNCHANGED.getValue());
        this.allowedSacScale.add("hiking");
        this.allowedSacScale.add("mountain_hiking");
        this.allowedSacScale.add("demanding_mountain_hiking");
        this.maxPossibleSpeed = 15;
    }

    @Override
    public TransportationMode getTransportationMode() {
        return TransportationMode.FOOT;
    }

    @Override
    public int getVersion() {
        return 5;
    }

    @Override
    public void createEncodedValues(List<EncodedValue> registerNewEncodedValue, String prefix, int index) {
        super.createEncodedValues(registerNewEncodedValue, prefix, index);
        this.avgSpeedEnc = new UnsignedDecimalEncodedValue(EncodingManager.getKey(prefix, "average_speed"), this.speedBits, this.speedFactor, this.speedTwoDirections);
        registerNewEncodedValue.add(this.avgSpeedEnc);
        this.priorityWayEncoder = new UnsignedDecimalEncodedValue(EncodingManager.getKey(prefix, "priority"), 4, PriorityCode.getFactor(1), this.speedTwoDirections);
        registerNewEncodedValue.add(this.priorityWayEncoder);
        this.footRouteEnc = this.getEnumEncodedValue(RouteNetwork.key("foot"), RouteNetwork.class);
    }

    @Override
    public EncodingManager.Access getAccess(ReaderWay way) {
        String highwayValue = way.getTag("highway");
        if (highwayValue == null) {
            String footTag;
            EncodingManager.Access acceptPotentially = EncodingManager.Access.CAN_SKIP;
            if (way.hasTag("route", (Collection<String>)this.ferries) && ((footTag = way.getTag("foot")) == null || this.intendedValues.contains(footTag))) {
                acceptPotentially = EncodingManager.Access.FERRY;
            }
            if (way.hasTag("railway", (Object)"platform")) {
                acceptPotentially = EncodingManager.Access.WAY;
            }
            if (way.hasTag("man_made", (Object)"pier")) {
                acceptPotentially = EncodingManager.Access.WAY;
            }
            if (!acceptPotentially.canSkip()) {
                if (way.hasTag(this.restrictions, (Collection<String>)this.restrictedValues) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way)) {
                    return EncodingManager.Access.CAN_SKIP;
                }
                return acceptPotentially;
            }
            return EncodingManager.Access.CAN_SKIP;
        }
        if (way.getTag("sac_scale") != null && !way.hasTag("sac_scale", this.allowedSacScale)) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (way.hasTag("foot", (Collection<String>)this.intendedValues)) {
            return EncodingManager.Access.WAY;
        }
        if (way.hasTag(this.restrictions, (Collection<String>)this.restrictedValues) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way)) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (way.hasTag("sidewalk", this.sidewalkValues)) {
            return EncodingManager.Access.WAY;
        }
        if (!this.allowedHighwayTags.contains(highwayValue)) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (way.hasTag("motorroad", (Object)"yes")) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (this.isBlockFords() && (way.hasTag("highway", (Object)"ford") || way.hasTag("ford", new String[0]))) {
            return EncodingManager.Access.CAN_SKIP;
        }
        if (this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(way)) {
            return EncodingManager.Access.CAN_SKIP;
        }
        return EncodingManager.Access.WAY;
    }

    @Override
    public IntsRef handleWayTags(IntsRef edgeFlags, ReaderWay way, EncodingManager.Access access) {
        if (access.canSkip()) {
            return edgeFlags;
        }
        Integer priorityFromRelation = this.routeMap.get((Object)this.footRouteEnc.getEnum(false, edgeFlags));
        this.accessEnc.setBool(false, edgeFlags, true);
        this.accessEnc.setBool(true, edgeFlags, true);
        if (!access.isFerry()) {
            String sacScale = way.getTag("sac_scale");
            if (sacScale != null) {
                this.setSpeed(edgeFlags, true, true, "hiking".equals(sacScale) ? 5.0 : 2.0);
            } else {
                this.setSpeed(edgeFlags, true, true, way.hasTag("highway", (Object)"steps") ? 3.0 : 5.0);
            }
        } else {
            priorityFromRelation = PriorityCode.SLIGHT_AVOID.getValue();
            double ferrySpeed = this.ferrySpeedCalc.getSpeed(way);
            this.setSpeed(edgeFlags, true, true, ferrySpeed);
        }
        this.priorityWayEncoder.setDecimal(false, edgeFlags, PriorityCode.getValue(this.handlePriority(way, priorityFromRelation)));
        return edgeFlags;
    }

    void setSpeed(IntsRef edgeFlags, boolean fwd, boolean bwd, double speed) {
        if (speed > this.getMaxSpeed()) {
            speed = this.getMaxSpeed();
        }
        if (fwd) {
            this.avgSpeedEnc.setDecimal(false, edgeFlags, speed);
        }
        if (bwd && this.speedTwoDirections) {
            this.avgSpeedEnc.setDecimal(true, edgeFlags, speed);
        }
    }

    int handlePriority(ReaderWay way, Integer priorityFromRelation) {
        TreeMap<Double, Integer> weightToPrioMap = new TreeMap<Double, Integer>();
        if (priorityFromRelation == null) {
            weightToPrioMap.put(0.0, PriorityCode.UNCHANGED.getValue());
        } else {
            weightToPrioMap.put(110.0, priorityFromRelation);
        }
        this.collect(way, weightToPrioMap);
        return weightToPrioMap.lastEntry().getValue();
    }

    void collect(ReaderWay way, TreeMap<Double, Integer> weightToPrioMap) {
        String highway = way.getTag("highway");
        if (way.hasTag("foot", (Object)"designated")) {
            weightToPrioMap.put(100.0, PriorityCode.PREFER.getValue());
        }
        double maxSpeed = this.getMaxSpeed(way);
        if (this.safeHighwayTags.contains(highway) || this.isValidSpeed(maxSpeed) && maxSpeed <= 20.0) {
            weightToPrioMap.put(40.0, PriorityCode.PREFER.getValue());
            if (way.hasTag("tunnel", (Collection<String>)this.intendedValues)) {
                if (way.hasTag("sidewalk", this.sidewalksNoValues)) {
                    weightToPrioMap.put(40.0, PriorityCode.SLIGHT_AVOID.getValue());
                } else {
                    weightToPrioMap.put(40.0, PriorityCode.UNCHANGED.getValue());
                }
            }
        } else if ((this.isValidSpeed(maxSpeed) && maxSpeed > 50.0 || this.avoidHighwayTags.contains(highway)) && !way.hasTag("sidewalk", this.sidewalkValues)) {
            weightToPrioMap.put(45.0, PriorityCode.SLIGHT_AVOID.getValue());
        }
        if (way.hasTag("bicycle", (Object)"official") || way.hasTag("bicycle", (Object)"designated")) {
            weightToPrioMap.put(44.0, PriorityCode.SLIGHT_AVOID.getValue());
        }
    }

    @Override
    public boolean supports(Class<?> feature) {
        if (super.supports(feature)) {
            return true;
        }
        return PriorityWeighting.class.isAssignableFrom(feature);
    }

    public String toString() {
        return "foot";
    }
}

