/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FerrySpeedCalculator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final double speedFactor;
    private final double unknownSpeed;
    private final double longSpeed;
    private final double shortSpeed;
    private final double maxSpeed;

    public FerrySpeedCalculator(double speedFactor, double maxSpeed, double longSpeed, double shortSpeed, double unknownSpeed) {
        this.speedFactor = speedFactor;
        this.unknownSpeed = unknownSpeed;
        this.longSpeed = longSpeed;
        this.shortSpeed = shortSpeed;
        this.maxSpeed = maxSpeed;
    }

    public double getSpeed(ReaderWay way) {
        long duration = 0L;
        try {
            duration = Long.parseLong(way.getTag("duration:seconds"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        double durationInHours = (double)duration / 60.0 / 60.0;
        Number estimatedLength = way.getTag("estimated_distance", null);
        if (durationInHours > 0.0) {
            try {
                if (estimatedLength != null) {
                    long firstId;
                    double estimatedLengthInKm = estimatedLength.doubleValue() / 1000.0;
                    double calculatedTripSpeed = estimatedLengthInKm / durationInHours / 1.4;
                    if (calculatedTripSpeed > 0.01) {
                        if (calculatedTripSpeed > this.maxSpeed) {
                            return this.maxSpeed;
                        }
                        if ((double)Math.round(calculatedTripSpeed) < this.speedFactor / 2.0) {
                            return this.speedFactor / 2.0;
                        }
                        return Math.round(calculatedTripSpeed);
                    }
                    long lastId = way.getNodes().isEmpty() ? -1L : way.getNodes().get(way.getNodes().size() - 1);
                    long l = firstId = way.getNodes().isEmpty() ? -1L : way.getNodes().get(0);
                    if (firstId != lastId) {
                        this.logger.warn("Unrealistic long duration ignored in way with way ID=" + way.getId() + " : Duration tag value=" + way.getTag("duration") + " (=" + Math.round((double)duration / 60.0) + " minutes)");
                    }
                    durationInHours = 0.0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (durationInHours == 0.0) {
            if (estimatedLength != null && estimatedLength.doubleValue() <= 300.0) {
                return this.speedFactor / 2.0;
            }
            return this.unknownSpeed;
        }
        if (durationInHours > 1.0) {
            return this.longSpeed;
        }
        return this.shortSpeed;
    }
}

