/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ConditionalTagInspector;
import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.osm.conditional.ConditionalOSMTagInspector;
import com.graphhopper.reader.osm.conditional.DateRangeParser;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.ev.StringEncodedValue;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FerrySpeedCalculator;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.parsers.OSMRoadAccessParser;
import com.graphhopper.routing.util.parsers.helpers.OSMValueExtractor;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.EdgeIteratorState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractFlagEncoder
implements FlagEncoder {
    protected final Set<String> intendedValues = new HashSet<String>(5);
    protected final List<String> restrictions = new ArrayList<String>(5);
    protected final Set<String> restrictedValues = new HashSet<String>(5);
    protected final Set<String> ferries = new HashSet<String>(5);
    protected final Set<String> oneways = new HashSet<String>(5);
    protected final Set<String> absoluteBarriers = new HashSet<String>(5);
    protected final Set<String> potentialBarriers = new HashSet<String>(5);
    protected final int speedBits;
    protected final double speedFactor;
    private final int maxTurnCosts;
    private long encoderBit;
    protected BooleanEncodedValue accessEnc;
    protected BooleanEncodedValue roundaboutEnc;
    protected DecimalEncodedValue avgSpeedEnc;
    protected int maxPossibleSpeed;
    private boolean blockByDefault = true;
    private boolean blockFords = true;
    private boolean registered;
    protected EncodedValueLookup encodedValueLookup;
    private ConditionalTagInspector conditionalTagInspector;
    protected FerrySpeedCalculator ferrySpeedCalc;

    protected AbstractFlagEncoder(int speedBits, double speedFactor, int maxTurnCosts) {
        this.maxTurnCosts = maxTurnCosts <= 0 ? 0 : maxTurnCosts;
        this.speedBits = speedBits;
        this.speedFactor = speedFactor;
        this.oneways.add("yes");
        this.oneways.add("true");
        this.oneways.add("1");
        this.oneways.add("-1");
        this.ferries.add("shuttle_train");
        this.ferries.add("ferry");
        this.restrictions.addAll(OSMRoadAccessParser.toOSMRestrictions(this.getTransportationMode()));
    }

    protected void init(DateRangeParser dateRangeParser) {
        this.ferrySpeedCalc = new FerrySpeedCalculator(this.speedFactor, this.maxPossibleSpeed, 30.0, 20.0, 5.0);
        this.setConditionalTagInspector(new ConditionalOSMTagInspector(Collections.singletonList(dateRangeParser), this.restrictions, this.restrictedValues, this.intendedValues, false));
    }

    protected void setConditionalTagInspector(ConditionalTagInspector inspector) {
        if (this.conditionalTagInspector != null) {
            throw new IllegalStateException("You must not register a FlagEncoder (" + this.toString() + ") twice or for two EncodingManagers!");
        }
        this.registered = true;
        this.conditionalTagInspector = inspector;
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    protected void blockBarriersByDefault(boolean blockByDefault) {
        this.blockByDefault = blockByDefault;
    }

    public boolean isBlockBarriers() {
        return this.blockByDefault;
    }

    public boolean isBlockFords() {
        return this.blockFords;
    }

    protected void blockFords(boolean blockFords) {
        this.blockFords = blockFords;
    }

    protected void blockPrivate(boolean blockPrivate) {
        if (!blockPrivate) {
            if (!this.restrictedValues.remove("private")) {
                throw new IllegalStateException("no 'private' found in restrictedValues");
            }
            this.intendedValues.add("private");
        }
    }

    public ConditionalTagInspector getConditionalTagInspector() {
        return this.conditionalTagInspector;
    }

    public void createEncodedValues(List<EncodedValue> registerNewEncodedValue, String prefix, int index) {
        this.accessEnc = new SimpleBooleanEncodedValue(EncodingManager.getKey(prefix, "access"), true);
        registerNewEncodedValue.add(this.accessEnc);
        this.roundaboutEnc = this.getBooleanEncodedValue("roundabout");
        this.encoderBit = 1L << index;
    }

    public abstract IntsRef handleWayTags(IntsRef var1, ReaderWay var2, EncodingManager.Access var3);

    public int getMaxTurnCosts() {
        return this.maxTurnCosts;
    }

    public abstract EncodingManager.Access getAccess(ReaderWay var1);

    public long handleNodeTags(ReaderNode node) {
        if (node.hasTag("barrier", this.absoluteBarriers)) {
            return this.encoderBit;
        }
        if (node.hasTag("barrier", this.potentialBarriers)) {
            boolean locked = false;
            if (node.hasTag("locked", (Object)"yes")) {
                locked = true;
            }
            for (String res : this.restrictions) {
                if (!locked && node.hasTag(res, this.intendedValues)) {
                    return 0L;
                }
                if (!node.hasTag(res, this.restrictedValues)) continue;
                return this.encoderBit;
            }
            if (this.blockByDefault) {
                return this.encoderBit;
            }
        }
        if ((node.hasTag("highway", (Object)"ford") || node.hasTag("ford", (Object)"yes")) && (this.blockFords && !node.hasTag(this.restrictions, this.intendedValues) || node.hasTag(this.restrictions, this.restrictedValues))) {
            return this.encoderBit;
        }
        return 0L;
    }

    @Override
    public double getMaxSpeed() {
        return this.maxPossibleSpeed;
    }

    protected double getMaxSpeed(ReaderWay way) {
        double backSpeed;
        double maxSpeed = OSMValueExtractor.stringToKmh(way.getTag("maxspeed"));
        double fwdSpeed = OSMValueExtractor.stringToKmh(way.getTag("maxspeed:forward"));
        if (this.isValidSpeed(fwdSpeed) && (!this.isValidSpeed(maxSpeed) || fwdSpeed < maxSpeed)) {
            maxSpeed = fwdSpeed;
        }
        if (this.isValidSpeed(backSpeed = OSMValueExtractor.stringToKmh(way.getTag("maxspeed:backward"))) && (!this.isValidSpeed(maxSpeed) || backSpeed < maxSpeed)) {
            maxSpeed = backSpeed;
        }
        return maxSpeed;
    }

    protected boolean isValidSpeed(double speed) {
        return !Double.isNaN(speed);
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + this.accessEnc.hashCode();
        hash = 61 * hash + this.toString().hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractFlagEncoder afe = (AbstractFlagEncoder)obj;
        return this.toString().equals(afe.toString()) && this.encoderBit == afe.encoderBit && this.accessEnc.equals(afe.accessEnc);
    }

    public void applyWayTags(ReaderWay way, EdgeIteratorState edge) {
    }

    @Override
    public final DecimalEncodedValue getAverageSpeedEnc() {
        if (this.avgSpeedEnc == null) {
            throw new NullPointerException("FlagEncoder " + this.toString() + " not yet initialized");
        }
        return this.avgSpeedEnc;
    }

    @Override
    public final BooleanEncodedValue getAccessEnc() {
        if (this.accessEnc == null) {
            throw new NullPointerException("FlagEncoder " + this.toString() + " not yet initialized");
        }
        return this.accessEnc;
    }

    protected void setSpeed(boolean reverse, IntsRef edgeFlags, double speed) {
        if (speed < this.speedFactor / 2.0) {
            this.avgSpeedEnc.setDecimal(reverse, edgeFlags, 0.0);
            this.accessEnc.setBool(reverse, edgeFlags, false);
        } else {
            this.avgSpeedEnc.setDecimal(reverse, edgeFlags, speed > this.getMaxSpeed() ? this.getMaxSpeed() : speed);
        }
    }

    protected double applyMaxSpeed(ReaderWay way, double speed) {
        double maxSpeed = this.getMaxSpeed(way);
        if (this.isValidSpeed(maxSpeed)) {
            return maxSpeed * 0.9;
        }
        return speed;
    }

    protected String getPropertiesString() {
        return "speed_factor=" + this.speedFactor + "|speed_bits=" + this.speedBits + "|turn_costs=" + (this.maxTurnCosts > 0);
    }

    @Override
    public List<EncodedValue> getEncodedValues() {
        return this.encodedValueLookup.getEncodedValues();
    }

    @Override
    public <T extends EncodedValue> T getEncodedValue(String key, Class<T> encodedValueType) {
        return this.encodedValueLookup.getEncodedValue(key, encodedValueType);
    }

    @Override
    public BooleanEncodedValue getBooleanEncodedValue(String key) {
        return this.encodedValueLookup.getBooleanEncodedValue(key);
    }

    @Override
    public IntEncodedValue getIntEncodedValue(String key) {
        return this.encodedValueLookup.getIntEncodedValue(key);
    }

    @Override
    public DecimalEncodedValue getDecimalEncodedValue(String key) {
        return this.encodedValueLookup.getDecimalEncodedValue(key);
    }

    @Override
    public <T extends Enum<?>> EnumEncodedValue<T> getEnumEncodedValue(String key, Class<T> enumType) {
        return this.encodedValueLookup.getEnumEncodedValue(key, enumType);
    }

    @Override
    public StringEncodedValue getStringEncodedValue(String key) {
        return this.encodedValueLookup.getStringEncodedValue(key);
    }

    public void setEncodedValueLookup(EncodedValueLookup encodedValueLookup) {
        this.encodedValueLookup = encodedValueLookup;
    }

    @Override
    public boolean supportsTurnCosts() {
        return this.maxTurnCosts > 0;
    }

    @Override
    public boolean supports(Class<?> feature) {
        return false;
    }

    @Override
    public boolean hasEncodedValue(String key) {
        return this.encodedValueLookup.hasEncodedValue(key);
    }

    public final List<String> getRestrictions() {
        return this.restrictions;
    }
}

