/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.BeelineWeightApproximator;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import java.util.Arrays;

public class LMApproximator
implements WeightApproximator {
    private final LandmarkStorage lms;
    private final Weighting weighting;
    private int[] activeLandmarkIndices;
    private int[] weightsFromActiveLandmarksToT;
    private int[] weightsFromTToActiveLandmarks;
    private double epsilon = 1.0;
    private int towerNodeNextToT = -1;
    private double weightFromTToTowerNode;
    private boolean recalculateActiveLandmarks = true;
    private final double factor;
    private final boolean reverse;
    private final int maxBaseNodes;
    private final Graph graph;
    private final WeightApproximator fallBackApproximation;
    private boolean fallback = false;

    public static LMApproximator forLandmarks(Graph g2, LandmarkStorage lms, int activeLM) {
        return new LMApproximator(g2, lms.getWeighting(), lms.getBaseNodes(), lms, activeLM, lms.getFactor(), false);
    }

    public LMApproximator(Graph graph, Weighting weighting, int maxBaseNodes, LandmarkStorage lms, int activeCount, double factor, boolean reverse) {
        this.reverse = reverse;
        this.lms = lms;
        this.factor = factor;
        if (activeCount > lms.getLandmarkCount()) {
            throw new IllegalArgumentException("Active landmarks " + activeCount + " should be lower or equals to landmark count " + lms.getLandmarkCount());
        }
        this.activeLandmarkIndices = new int[activeCount];
        Arrays.fill(this.activeLandmarkIndices, -1);
        this.weightsFromActiveLandmarksToT = new int[activeCount];
        this.weightsFromTToActiveLandmarks = new int[activeCount];
        this.graph = graph;
        this.weighting = weighting;
        this.fallBackApproximation = new BeelineWeightApproximator(graph.getNodeAccess(), weighting);
        this.maxBaseNodes = maxBaseNodes;
    }

    public LMApproximator setEpsilon(double epsilon) {
        this.epsilon = epsilon;
        return this;
    }

    @Override
    public double approximate(int v) {
        if (!this.recalculateActiveLandmarks && this.fallback || this.lms.isEmpty()) {
            return this.fallBackApproximation.approximate(v);
        }
        if (v >= this.maxBaseNodes) {
            return 0.0;
        }
        if (v == this.towerNodeNextToT) {
            return 0.0;
        }
        if (this.recalculateActiveLandmarks) {
            this.recalculateActiveLandmarks = false;
            if (this.lms.chooseActiveLandmarks(v, this.towerNodeNextToT, this.activeLandmarkIndices, this.reverse)) {
                for (int i = 0; i < this.activeLandmarkIndices.length; ++i) {
                    this.weightsFromActiveLandmarksToT[i] = this.lms.getFromWeight(this.activeLandmarkIndices[i], this.towerNodeNextToT);
                    this.weightsFromTToActiveLandmarks[i] = this.lms.getToWeight(this.activeLandmarkIndices[i], this.towerNodeNextToT);
                }
            } else {
                this.fallback = true;
                return this.fallBackApproximation.approximate(v);
            }
        }
        return Math.max(0.0, (this.getRemainingWeightUnderestimationUpToTowerNode(v) - this.weightFromTToTowerNode) * this.epsilon);
    }

    private double getRemainingWeightUnderestimationUpToTowerNode(int v) {
        int maxWeightInt = 0;
        for (int i = 0; i < this.activeLandmarkIndices.length; ++i) {
            int resultInt = this.approximateForLandmark(i, v);
            maxWeightInt = Math.max(maxWeightInt, resultInt);
        }
        return (double)(maxWeightInt - 1) * this.factor;
    }

    private int approximateForLandmark(int i, int v) {
        int rhs1Int = this.weightsFromActiveLandmarksToT[i] - this.lms.getFromWeight(this.activeLandmarkIndices[i], v);
        int rhs2Int = this.lms.getToWeight(this.activeLandmarkIndices[i], v) - this.weightsFromTToActiveLandmarks[i];
        int resultInt = this.reverse ? Math.max(-rhs2Int, -rhs1Int) : Math.max(rhs1Int, rhs2Int);
        return resultInt;
    }

    @Override
    public void setTo(int t) {
        this.fallBackApproximation.setTo(t);
        this.findClosestRealNode(t);
    }

    private void findClosestRealNode(int t) {
        Dijkstra dijkstra = new Dijkstra(this.graph, this.weighting, TraversalMode.NODE_BASED){

            @Override
            protected boolean finished() {
                LMApproximator.this.towerNodeNextToT = this.currEdge.adjNode;
                LMApproximator.this.weightFromTToTowerNode = this.currEdge.weight;
                return this.currEdge.adjNode < LMApproximator.this.maxBaseNodes;
            }

            @Override
            protected void initCollections(int size) {
                super.initCollections(2);
            }
        };
        dijkstra.calcPath(t, -1);
    }

    @Override
    public WeightApproximator reverse() {
        return new LMApproximator(this.graph, this.weighting, this.maxBaseNodes, this.lms, this.activeLandmarkIndices.length, this.factor, !this.reverse);
    }

    @Override
    public double getSlack() {
        return this.lms.getFactor();
    }

    public void triggerActiveLandmarkRecalculation() {
        this.recalculateActiveLandmarks = true;
    }

    public String toString() {
        return "landmarks";
    }
}

