/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.matching;

import com.graphhopper.matching.Observation;
import com.graphhopper.routing.querygraph.VirtualEdgeIteratorState;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.EdgeIteratorState;

public class State {
    private final Observation entry;
    private final Snap snap;
    private final boolean isDirected;
    private final EdgeIteratorState incomingVirtualEdge;
    private final EdgeIteratorState outgoingVirtualEdge;

    public State(Observation entry, Snap snap) {
        this.entry = entry;
        this.snap = snap;
        this.isDirected = false;
        this.incomingVirtualEdge = null;
        this.outgoingVirtualEdge = null;
    }

    public State(Observation entry, Snap snap, VirtualEdgeIteratorState incomingVirtualEdge, VirtualEdgeIteratorState outgoingVirtualEdge) {
        this.entry = entry;
        this.snap = snap;
        this.isDirected = true;
        this.incomingVirtualEdge = incomingVirtualEdge;
        this.outgoingVirtualEdge = outgoingVirtualEdge;
    }

    public Observation getEntry() {
        return this.entry;
    }

    public Snap getSnap() {
        return this.snap;
    }

    public boolean isOnDirectedEdge() {
        return this.isDirected;
    }

    public EdgeIteratorState getIncomingVirtualEdge() {
        if (!this.isDirected) {
            throw new IllegalStateException("This method may only be called for directed GPXExtensions");
        }
        return this.incomingVirtualEdge;
    }

    public EdgeIteratorState getOutgoingVirtualEdge() {
        if (!this.isDirected) {
            throw new IllegalStateException("This method may only be called for directed GPXExtensions");
        }
        return this.outgoingVirtualEdge;
    }

    public String toString() {
        return "State{closest node=" + this.snap.getClosestNode() + " at " + this.snap.getSnappedPoint().getLat() + "," + this.snap.getSnappedPoint().getLon() + ", incomingEdge=" + this.incomingVirtualEdge + ", outgoingEdge=" + this.outgoingVirtualEdge + '}';
    }
}

