/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jackson;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.GHResponse;
import com.graphhopper.ResponsePath;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class ResponsePathSerializer {
    public static final List<String> COPYRIGHTS = Arrays.asList("GraphHopper", "OpenStreetMap contributors");

    public static String encodePolyline(PointList poly, boolean includeElevation, double precision) {
        StringBuilder sb = new StringBuilder(Math.max(20, poly.size() * 3));
        int size = poly.size();
        int prevLat = 0;
        int prevLon = 0;
        int prevEle = 0;
        for (int i = 0; i < size; ++i) {
            int num = (int)Math.floor(poly.getLat(i) * precision);
            ResponsePathSerializer.encodeNumber(sb, num - prevLat);
            prevLat = num;
            num = (int)Math.floor(poly.getLon(i) * precision);
            ResponsePathSerializer.encodeNumber(sb, num - prevLon);
            prevLon = num;
            if (!includeElevation) continue;
            num = (int)Math.floor(poly.getEle(i) * 100.0);
            ResponsePathSerializer.encodeNumber(sb, num - prevEle);
            prevEle = num;
        }
        return sb.toString();
    }

    private static void encodeNumber(StringBuilder sb, int num) {
        if ((num <<= 1) < 0) {
            num ^= 0xFFFFFFFF;
        }
        while (num >= 32) {
            int nextValue = (0x20 | num & 0x1F) + 63;
            sb.append((char)nextValue);
            num >>= 5;
        }
        sb.append((char)(num += 63));
    }

    public static ObjectNode jsonObject(GHResponse ghRsp, boolean enableInstructions, boolean calcPoints, boolean enableElevation, boolean pointsEncoded, float took) {
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        json.putPOJO("hints", ghRsp.getHints().toMap());
        ObjectNode info = json.putObject("info");
        info.putPOJO("copyrights", COPYRIGHTS);
        info.put("took", Math.round(took));
        ArrayNode jsonPathList = json.putArray("paths");
        for (ResponsePath p : ghRsp.getAll()) {
            ObjectNode jsonPath = jsonPathList.addObject();
            jsonPath.put("distance", Helper.round(p.getDistance(), 3));
            jsonPath.put("weight", Helper.round6(p.getRouteWeight()));
            jsonPath.put("time", p.getTime());
            jsonPath.put("transfers", p.getNumChanges());
            if (!p.getDescription().isEmpty()) {
                jsonPath.putPOJO("description", p.getDescription());
            }
            if (calcPoints) {
                jsonPath.put("points_encoded", pointsEncoded);
                if (p.getPoints().size() >= 2) {
                    jsonPath.putPOJO("bbox", p.calcBBox2D());
                }
                jsonPath.putPOJO("points", pointsEncoded ? ResponsePathSerializer.encodePolyline(p.getPoints(), enableElevation, 100000.0) : p.getPoints().toLineString(enableElevation));
                if (enableInstructions) {
                    jsonPath.putPOJO("instructions", p.getInstructions());
                }
                jsonPath.putPOJO("legs", p.getLegs());
                jsonPath.putPOJO("details", p.getPathDetails());
                jsonPath.put("ascend", p.getAscend());
                jsonPath.put("descend", p.getDescend());
            }
            jsonPath.putPOJO("snapped_waypoints", pointsEncoded ? ResponsePathSerializer.encodePolyline(p.getWaypoints(), enableElevation, 100000.0) : p.getWaypoints().toLineString(enableElevation));
            if (p.getFare() == null) continue;
            jsonPath.put("fare", NumberFormat.getCurrencyInstance(Locale.ROOT).format(p.getFare()));
        }
        return json;
    }
}

