/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper;

import com.graphhopper.ResponsePath;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.List;

public class GHResponse {
    private final List<Throwable> errors = new ArrayList<Throwable>(4);
    private final PMap hintsMap = new PMap();
    private final List<ResponsePath> responsePaths = new ArrayList<ResponsePath>(5);
    private String debugInfo = "";

    public void add(ResponsePath responsePath) {
        this.responsePaths.add(responsePath);
    }

    public ResponsePath getBest() {
        if (this.responsePaths.isEmpty()) {
            throw new RuntimeException("Cannot fetch best response if list is empty");
        }
        return this.responsePaths.get(0);
    }

    public List<ResponsePath> getAll() {
        return this.responsePaths;
    }

    public boolean hasAlternatives() {
        return this.responsePaths.size() > 1;
    }

    public void addDebugInfo(String debugInfo) {
        if (debugInfo == null) {
            throw new IllegalStateException("Debug information has to be none null");
        }
        if (!this.debugInfo.isEmpty()) {
            this.debugInfo = this.debugInfo + "; ";
        }
        this.debugInfo = this.debugInfo + debugInfo;
    }

    public String getDebugInfo() {
        String str = this.debugInfo;
        for (ResponsePath p : this.responsePaths) {
            if (!str.isEmpty()) {
                str = str + "; ";
            }
            str = str + p.getDebugInfo();
        }
        return str;
    }

    public boolean hasErrors() {
        if (!this.errors.isEmpty()) {
            return true;
        }
        for (ResponsePath p : this.responsePaths) {
            if (!p.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public List<Throwable> getErrors() {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        list.addAll(this.errors);
        for (ResponsePath p : this.responsePaths) {
            list.addAll(p.getErrors());
        }
        return list;
    }

    public GHResponse addErrors(List<Throwable> errors) {
        this.errors.addAll(errors);
        return this;
    }

    public GHResponse addError(Throwable error) {
        this.errors.add(error);
        return this;
    }

    public String toString() {
        String str = "";
        for (ResponsePath a : this.responsePaths) {
            str = str + "; " + a.toString();
        }
        if (this.responsePaths.isEmpty()) {
            str = "no paths";
        }
        if (!this.errors.isEmpty()) {
            str = str + ", main errors: " + this.errors.toString();
        }
        return str;
    }

    public PMap getHints() {
        return this.hintsMap;
    }
}

