/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RoutingCHEdgeExplorer;
import com.graphhopper.storage.RoutingCHEdgeIteratorImpl;
import com.graphhopper.storage.RoutingCHEdgeIteratorState;
import com.graphhopper.storage.RoutingCHEdgeIteratorStateImpl;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.util.CHEdgeIteratorState;

public class RoutingCHGraphImpl
implements RoutingCHGraph {
    private final Graph baseGraph;
    private final CHGraph chGraph;
    private final Weighting weighting;

    public RoutingCHGraphImpl(CHGraph chGraph) {
        Weighting weighting = chGraph.getCHConfig().getWeighting();
        if (weighting.hasTurnCosts() && !chGraph.getCHConfig().isEdgeBased()) {
            throw new IllegalArgumentException("Weighting has turn costs, but CHGraph is node-based");
        }
        this.chGraph = chGraph;
        this.baseGraph = chGraph.getBaseGraph();
        this.weighting = weighting;
    }

    @Override
    public int getNodes() {
        return this.chGraph.getNodes();
    }

    @Override
    public int getEdges() {
        return this.chGraph.getEdges();
    }

    @Override
    public int getOtherNode(int chEdge, int node) {
        return this.chGraph.getOtherNode(chEdge, node);
    }

    @Override
    public boolean isAdjacentToNode(int chEdge, int node) {
        return this.chGraph.isAdjacentToNode(chEdge, node);
    }

    @Override
    public RoutingCHEdgeExplorer createInEdgeExplorer() {
        return RoutingCHEdgeIteratorImpl.inEdges(this.chGraph.createEdgeExplorer(), this.weighting);
    }

    @Override
    public RoutingCHEdgeExplorer createOutEdgeExplorer() {
        return RoutingCHEdgeIteratorImpl.outEdges(this.chGraph.createEdgeExplorer(), this.weighting);
    }

    @Override
    public RoutingCHEdgeIteratorState getEdgeIteratorState(int chEdge, int adjNode) {
        CHEdgeIteratorState edgeState = this.chGraph.getEdgeIteratorState(chEdge, adjNode);
        return edgeState == null ? null : new RoutingCHEdgeIteratorStateImpl(edgeState, this.weighting);
    }

    @Override
    public int getLevel(int node) {
        return this.chGraph.getLevel(node);
    }

    @Override
    public Graph getBaseGraph() {
        return this.baseGraph;
    }

    @Override
    public Weighting getWeighting() {
        return this.weighting;
    }

    @Override
    public boolean hasTurnCosts() {
        return this.weighting.hasTurnCosts();
    }

    @Override
    public boolean isEdgeBased() {
        return this.chGraph.getCHConfig().isEdgeBased();
    }

    @Override
    public double getTurnWeight(int edgeFrom, int nodeVia, int edgeTo) {
        return this.weighting.calcTurnWeight(edgeFrom, nodeVia, edgeTo);
    }
}

