/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.Circle;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.Polygon;
import com.graphhopper.util.shapes.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.locationtech.jts.algorithm.RectangleLineIntersector;

public class GraphEdgeIdFinder {
    private static final int P_RADIUS = 5;
    private final Graph graph;
    private final LocationIndex locationIndex;

    public GraphEdgeIdFinder(Graph graph, LocationIndex locationIndex) {
        this.graph = graph;
        this.locationIndex = locationIndex;
    }

    static double calculateArea(Shape shape) {
        if (shape instanceof BBox) {
            return GraphEdgeIdFinder.calculateArea((BBox)shape);
        }
        if (shape instanceof Polygon) {
            return GraphEdgeIdFinder.calculateArea((Polygon)shape);
        }
        if (shape instanceof Circle) {
            return GraphEdgeIdFinder.calculateArea((Circle)shape);
        }
        throw new IllegalStateException("Unsupported shape: " + shape);
    }

    static double calculateArea(BBox bBox) {
        double meanLat = (bBox.maxLat + bBox.minLat) / 2.0;
        return DistancePlaneProjection.DIST_PLANE.calcDist(meanLat, bBox.minLon, meanLat, bBox.maxLon) * DistancePlaneProjection.DIST_PLANE.calcDist(bBox.minLat, bBox.minLon, bBox.maxLat, bBox.minLon);
    }

    static double calculateArea(Polygon polygon) {
        return GraphEdgeIdFinder.calculateArea(polygon.getBounds()) * polygon.envelope.getArea() / polygon.prepPolygon.getGeometry().getArea();
    }

    static double calculateArea(Circle circle) {
        return Math.PI * circle.radiusInMeter * circle.radiusInMeter;
    }

    private GHIntHashSet findEdgesInShape(Shape shape, EdgeFilter filter) {
        GHIntHashSet edgeIds = new GHIntHashSet();
        this.locationIndex.query(shape.getBounds(), edgeId -> {
            EdgeIteratorState edge = this.graph.getEdgeIteratorStateForKey(edgeId * 2);
            if (filter.accept(edge) && shape.intersects(edge.fetchWayGeometry(FetchMode.ALL).makeImmutable())) {
                edgeIds.add(edge.getEdge());
            }
        });
        return edgeIds;
    }

    public static BlockArea createBlockArea(Graph graph, LocationIndex locationIndex, List<GHPoint> points, PMap hints, EdgeFilter edgeFilter) {
        String blockAreaStr = hints.getString("block_area", "");
        BlockArea blockArea = new GraphEdgeIdFinder(graph, locationIndex).parseBlockArea(blockAreaStr, edgeFilter, hints.getDouble("block_area.edge_id_max_area", 1000000.0));
        for (GHPoint p : points) {
            if (!blockArea.contains(p)) continue;
            throw new IllegalArgumentException("Request with block_area contained query point " + p + ". This is not allowed.");
        }
        return blockArea;
    }

    public BlockArea parseBlockArea(String blockAreaString, EdgeFilter filter, double useEdgeIdsUntilAreaSize) {
        String objectSeparator = ";";
        String innerObjSep = ",";
        BlockArea blockArea = new BlockArea(this.graph);
        if (!blockAreaString.isEmpty()) {
            String[] blockedCircularAreasArr = blockAreaString.split(";");
            for (int i = 0; i < blockedCircularAreasArr.length; ++i) {
                double lon;
                Shape shape;
                String objectAsString = blockedCircularAreasArr[i];
                String[] splittedObject = objectAsString.split(",");
                boolean point = false;
                if (splittedObject.length > 4) {
                    shape = Polygon.parsePoints(objectAsString);
                } else if (splittedObject.length == 4) {
                    BBox bbox = BBox.parseTwoPoints(objectAsString);
                    final RectangleLineIntersector cachedIntersector = new RectangleLineIntersector(BBox.toEnvelope(bbox));
                    shape = new BBox(bbox.minLon, bbox.maxLon, bbox.minLat, bbox.maxLat){

                        @Override
                        public boolean intersects(PointList pointList) {
                            return BBox.intersects(cachedIntersector, pointList);
                        }
                    };
                } else if (splittedObject.length == 3) {
                    double lat = Double.parseDouble(splittedObject[0]);
                    lon = Double.parseDouble(splittedObject[1]);
                    int radius = Integer.parseInt(splittedObject[2]);
                    shape = new Circle(lat, lon, radius);
                } else if (splittedObject.length == 2) {
                    double lat = Double.parseDouble(splittedObject[0]);
                    lon = Double.parseDouble(splittedObject[1]);
                    shape = new Circle(lat, lon, 5.0);
                    point = true;
                } else {
                    throw new IllegalArgumentException(objectAsString + " at index " + i + " need to be defined as lat,lon or as a circle lat,lon,radius or rectangular lat1,lon1,lat2,lon2");
                }
                if (point || GraphEdgeIdFinder.calculateArea(shape) <= useEdgeIdsUntilAreaSize) {
                    GHIntHashSet blockedEdges = this.findEdgesInShape(shape, filter);
                    if (blockedEdges.isEmpty()) continue;
                    blockArea.add(shape, blockedEdges);
                    continue;
                }
                blockArea.add(shape);
            }
        }
        return blockArea;
    }

    public static class BlockArea {
        private final List<GHIntHashSet> edgesList = new ArrayList<GHIntHashSet>();
        private final List<Shape> blockedShapes = new ArrayList<Shape>();
        private final int baseEdgeCount;

        public BlockArea(Graph g2) {
            this.baseEdgeCount = g2.getAllEdges().length();
        }

        public boolean hasCachedEdgeIds(int shapeIndex) {
            return !this.edgesList.get(shapeIndex).isEmpty();
        }

        public String toString(int shapeIndex) {
            ArrayList<Integer> returnList = new ArrayList<Integer>();
            for (IntCursor intCursor : this.edgesList.get(shapeIndex)) {
                returnList.add(intCursor.value);
            }
            Collections.sort(returnList);
            return ((Object)returnList).toString();
        }

        public void add(Shape shape) {
            this.add(shape, new GHIntHashSet());
        }

        public void add(Shape shape, GHIntHashSet blockedEdgeIds) {
            this.blockedShapes.add(shape);
            this.edgesList.add(Objects.requireNonNull(blockedEdgeIds));
        }

        public final boolean contains(GHPoint point) {
            for (Shape shape : this.blockedShapes) {
                if (!shape.contains(point.lat, point.lon)) continue;
                return true;
            }
            return false;
        }

        public final boolean intersects(EdgeIteratorState edgeState) {
            PointList pointList = null;
            BBox bbox = null;
            for (int shapeIdx = 0; shapeIdx < this.blockedShapes.size(); ++shapeIdx) {
                Shape shape;
                GHIntHashSet blockedEdges = this.edgesList.get(shapeIdx);
                if (!blockedEdges.isEmpty() && edgeState.getEdge() < this.baseEdgeCount) {
                    if (!blockedEdges.contains(edgeState.getEdge())) continue;
                    return true;
                }
                if (bbox == null) {
                    bbox = GHUtility.createBBox(edgeState);
                }
                if (!(shape = this.blockedShapes.get(shapeIdx)).getBounds().intersects(bbox)) continue;
                if (pointList == null) {
                    pointList = edgeState.fetchWayGeometry(FetchMode.ALL).makeImmutable();
                }
                if (!shape.intersects(pointList)) continue;
                return true;
            }
            return false;
        }
    }
}

