/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.util.Helper;

public class DAType {
    public static final DAType RAM = new DAType(MemRef.HEAP, false, false, true);
    public static final DAType RAM_INT = new DAType(MemRef.HEAP, false, true, true);
    public static final DAType RAM_STORE = new DAType(MemRef.HEAP, true, false, true);
    public static final DAType RAM_INT_STORE = new DAType(MemRef.HEAP, true, true, true);
    public static final DAType MMAP = new DAType(MemRef.MMAP, true, false, true);
    public static final DAType MMAP_RO = new DAType(MemRef.MMAP, true, false, false);
    private final MemRef memRef;
    private final boolean storing;
    private final boolean integ;
    private final boolean allowWrites;

    public DAType(DAType type) {
        this(type.getMemRef(), type.isStoring(), type.isInteg(), type.isAllowWrites());
    }

    public DAType(MemRef memRef, boolean storing, boolean integ, boolean allowWrites) {
        this.memRef = memRef;
        this.storing = storing;
        this.integ = integ;
        this.allowWrites = allowWrites;
    }

    public static DAType fromString(String dataAccess) {
        DAType type;
        if ((dataAccess = Helper.toUpperCase(dataAccess)).contains("SYNC")) {
            throw new IllegalArgumentException("SYNC option is no longer supported, see #982");
        }
        if (dataAccess.contains("MMAP_RO")) {
            type = MMAP_RO;
        } else if (dataAccess.contains("MMAP")) {
            type = MMAP;
        } else {
            if (dataAccess.contains("UNSAFE")) {
                throw new IllegalArgumentException("UNSAFE option is no longer supported, see #1620");
            }
            type = dataAccess.contains("RAM_STORE") ? RAM_STORE : RAM;
        }
        return type;
    }

    public static DAType getPreferredInt(DAType type) {
        if (type.isInMemory()) {
            return type.isStoring() ? RAM_INT_STORE : RAM_INT;
        }
        return type;
    }

    MemRef getMemRef() {
        return this.memRef;
    }

    public boolean isAllowWrites() {
        return this.allowWrites;
    }

    public boolean isInMemory() {
        return this.memRef == MemRef.HEAP;
    }

    public boolean isMMap() {
        return this.memRef == MemRef.MMAP;
    }

    public boolean isStoring() {
        return this.storing;
    }

    public boolean isInteg() {
        return this.integ;
    }

    public String toString() {
        String str = this.getMemRef() == MemRef.MMAP ? "MMAP" : "RAM";
        if (this.isInteg()) {
            str = str + "_INT";
        }
        if (this.isStoring()) {
            str = str + "_STORE";
        }
        return str;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + 37 * this.memRef.hashCode();
        hash = 59 * hash + (this.storing ? 1 : 0);
        hash = 59 * hash + (this.integ ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DAType other = (DAType)obj;
        if (this.memRef != other.memRef) {
            return false;
        }
        if (this.storing != other.storing) {
            return false;
        }
        return this.integ == other.integ;
    }

    public static enum MemRef {
        HEAP,
        MMAP;

    }
}

