/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.JsonFeature;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.Polygon;
import java.util.Map;

public class CustomWeightingHelper {
    protected DecimalEncodedValue avg_speed_enc;

    protected CustomWeightingHelper() {
    }

    public void init(EncodedValueLookup lookup, DecimalEncodedValue avgSpeedEnc, Map<String, JsonFeature> areas) {
        this.avg_speed_enc = avgSpeedEnc;
    }

    public double getPriority(EdgeIteratorState edge, boolean reverse) {
        return 1.0;
    }

    public double getSpeed(EdgeIteratorState edge, boolean reverse) {
        return this.getRawSpeed(edge, reverse);
    }

    protected final double getRawSpeed(EdgeIteratorState edge, boolean reverse) {
        double speed;
        double d = speed = reverse ? edge.getReverse(this.avg_speed_enc) : edge.get(this.avg_speed_enc);
        if (Double.isInfinite(speed) || Double.isNaN(speed) || speed < 0.0) {
            throw new IllegalStateException("Invalid estimated speed " + speed);
        }
        return speed;
    }

    public static boolean in(Polygon p, EdgeIteratorState edge) {
        BBox bbox = GHUtility.createBBox(edge);
        if (p.getBounds().intersects(bbox)) {
            return p.intersects(edge.fetchWayGeometry(FetchMode.ALL).makeImmutable());
        }
        return false;
    }
}

