/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.subnetwork;

import com.graphhopper.storage.DAType;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Storable;

public class SubnetworkStorage
implements Storable<SubnetworkStorage> {
    private final DataAccess da;

    public SubnetworkStorage(Directory dir, String postfix) {
        DAType type = dir.getDefaultType();
        this.da = dir.find("subnetwork_" + postfix, type.isMMap() ? DAType.MMAP : (type.isStoring() ? DAType.RAM_STORE : DAType.RAM));
    }

    public int getSubnetwork(int nodeId) {
        return this.da.getByte(nodeId);
    }

    public void setSubnetwork(int nodeId, int subnetwork) {
        if (subnetwork > 127) {
            throw new IllegalArgumentException("Number of subnetworks is currently limited to 127 but requested " + subnetwork);
        }
        this.da.setByte(nodeId, (byte)subnetwork);
    }

    @Override
    public boolean loadExisting() {
        return this.da.loadExisting();
    }

    @Override
    public SubnetworkStorage create(long byteCount) {
        this.da.create(2000L);
        this.da.ensureCapacity(byteCount);
        return this;
    }

    @Override
    public void flush() {
        this.da.flush();
    }

    @Override
    public void close() {
        this.da.close();
    }

    @Override
    public boolean isClosed() {
        return this.da.isClosed();
    }

    @Override
    public long getCapacity() {
        return this.da.getCapacity();
    }
}

