/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.graphhopper.GraphHopper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.Profile;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.Constants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.locationtech.jts.geom.Envelope;

@Path(value="info")
@Produces(value={"application/json"})
public class InfoResource {
    private final GraphHopperConfig config;
    private final GraphHopperStorage storage;
    private final boolean hasElevation;

    @Inject
    public InfoResource(GraphHopperConfig config, GraphHopper graphHopper, @Named(value="hasElevation") Boolean hasElevation) {
        this.config = config;
        this.storage = graphHopper.getGraphHopperStorage();
        this.hasElevation = hasElevation;
    }

    @GET
    public Info getInfo() {
        Info info = new Info();
        info.bbox = new Envelope(this.storage.getBounds().minLon, this.storage.getBounds().maxLon, this.storage.getBounds().minLat, this.storage.getBounds().maxLat);
        for (Profile p : this.config.getProfiles()) {
            Info.ProfileData profileData = new Info.ProfileData(p.getName(), p.getVehicle());
            info.profiles.add(profileData);
        }
        if (this.config.has("gtfs.file")) {
            info.profiles.add(new Info.ProfileData("pt", "pt"));
        }
        info.elevation = this.hasElevation;
        List<String> encoderNames = Arrays.asList(this.storage.getEncodingManager().toString().split(","));
        info.supported_vehicles = new ArrayList<String>(encoderNames);
        if (this.config.has("gtfs.file")) {
            info.supported_vehicles.add("pt");
        }
        info.import_date = this.storage.getProperties().get("datareader.import.date");
        info.data_date = this.storage.getProperties().get("datareader.data.date");
        List<EncodedValue> evList = this.storage.getEncodingManager().getEncodedValues();
        info.encoded_values = new LinkedHashMap<String, List<Object>>();
        for (EncodedValue encodedValue : evList) {
            ArrayList<String> possibleValueList = new ArrayList<String>();
            if (!encodedValue.getName().contains("turn_costs")) {
                if (encodedValue instanceof EnumEncodedValue) {
                    for (Enum o : ((EnumEncodedValue)encodedValue).getValues()) {
                        possibleValueList.add(o.name());
                    }
                } else if (encodedValue instanceof BooleanEncodedValue) {
                    possibleValueList.add("true");
                    possibleValueList.add("false");
                } else {
                    if (!(encodedValue instanceof DecimalEncodedValue) && !(encodedValue instanceof IntEncodedValue)) continue;
                    possibleValueList.add(">number");
                    possibleValueList.add("<number");
                }
            }
            info.encoded_values.put(encodedValue.getName(), possibleValueList);
        }
        return info;
    }

    public static class Info {
        public Envelope bbox;
        public final List<ProfileData> profiles = new ArrayList<ProfileData>();
        public List<String> supported_vehicles;
        public String version = Constants.VERSION;
        public boolean elevation;
        public Map<String, List<Object>> encoded_values;
        public String import_date;
        public String data_date;

        public static class ProfileData {
            public String name;
            public String vehicle;

            public ProfileData() {
            }

            public ProfileData(String name, String vehicle) {
                this.name = name;
                this.vehicle = vehicle;
            }
        }
    }
}

