/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.Locale;

public class GtfsHelper {
    private static final int SECONDS_IN_MINUTE = 60;
    private static final int MINUTES_IN_HOUR = 60;
    private static final int HOURS_IN_DAY = 24;
    private static final int SECONDS_IN_HOUR = 3600;

    private GtfsHelper() {
    }

    public static int time(int hours, int minutes, int seconds) {
        return (hours * 3600 + minutes * 60 + seconds) * 1000;
    }

    public static int time(int hours, int minutes) {
        return GtfsHelper.time(hours, minutes, 0);
    }

    public static int time(LocalDateTime localDateTime) {
        return GtfsHelper.time(localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
    }

    public static int time(LocalTime localTime) {
        return GtfsHelper.time(localTime.getHour(), localTime.getMinute(), localTime.getSecond());
    }

    public static LocalDateTime localDateTimeFromDate(Date date) {
        return LocalDateTime.parse(new SimpleDateFormat("YYYY-MM-dd'T'HH:mm", Locale.ROOT).format(date));
    }
}

