/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.debatty.java.stringsimilarity;

import java.util.Arrays;

public class JaroWinkler {
    private static final double DEFAULT_THRESHOLD = 0.7;
    private static final int THREE = 3;
    private static final double JW_COEF = 0.1;
    private final double threshold;

    public JaroWinkler() {
        this.threshold = 0.7;
    }

    public JaroWinkler(double threshold) {
        this.threshold = threshold;
    }

    public final double getThreshold() {
        return this.threshold;
    }

    public final double similarity(String s1, String s2) {
        double j;
        int[] mtp = this.matches(s1, s2);
        float m3 = mtp[0];
        if (m3 == 0.0f) {
            return 0.0;
        }
        double jw = j = (double)((m3 / (float)s1.length() + m3 / (float)s2.length() + (m3 - (float)mtp[1]) / m3) / 3.0f);
        if (j > this.getThreshold()) {
            jw = j + Math.min(0.1, 1.0 / (double)mtp[3]) * (double)mtp[2] * (1.0 - j);
        }
        return jw;
    }

    public final double distance(String s1, String s2) {
        return 1.0 - this.similarity(s1, s2);
    }

    private int[] matches(String s1, String s2) {
        int i;
        String min2;
        String max;
        if (s1.length() > s2.length()) {
            max = s1;
            min2 = s2;
        } else {
            max = s2;
            min2 = s1;
        }
        int range = Math.max(max.length() / 2 - 1, 0);
        int[] matchIndexes = new int[min2.length()];
        Arrays.fill(matchIndexes, -1);
        boolean[] matchFlags = new boolean[max.length()];
        int matches = 0;
        block0: for (int mi = 0; mi < min2.length(); ++mi) {
            char c1 = min2.charAt(mi);
            int xn = Math.min(mi + range + 1, max.length());
            for (int xi = Math.max(mi - range, 0); xi < xn; ++xi) {
                if (matchFlags[xi] || c1 != max.charAt(xi)) continue;
                matchIndexes[mi] = xi;
                matchFlags[xi] = true;
                ++matches;
                continue block0;
            }
        }
        char[] ms1 = new char[matches];
        char[] ms2 = new char[matches];
        int si = 0;
        for (i = 0; i < min2.length(); ++i) {
            if (matchIndexes[i] == -1) continue;
            ms1[si] = min2.charAt(i);
            ++si;
        }
        si = 0;
        for (i = 0; i < max.length(); ++i) {
            if (!matchFlags[i]) continue;
            ms2[si] = max.charAt(i);
            ++si;
        }
        int transpositions = 0;
        for (int mi = 0; mi < ms1.length; ++mi) {
            if (ms1[mi] == ms2[mi]) continue;
            ++transpositions;
        }
        int prefix = 0;
        for (int mi = 0; mi < min2.length() && s1.charAt(mi) == s2.charAt(mi); ++mi) {
            ++prefix;
        }
        return new int[]{matches, transpositions / 2, prefix, max.length()};
    }
}

